/*
 * Decompiled with CFR 0.152.
 */
package axo.dev.rpdepent.utilis;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class configScrapper {
    private static final String TARGET_NAME = "RPD.txt";

    private configScrapper() {
    }

    public static void processRpdFiles(Path rootDir, Consumer<String> lineHandler) throws IOException {
        if (rootDir == null) {
            throw new IllegalArgumentException("rootDir must not be null");
        }
        if (lineHandler == null) {
            throw new IllegalArgumentException("lineHandler must not be null");
        }
        try (Stream<Path> stream = Files.walk(rootDir, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                block15: {
                    String fileName = p.getFileName() != null ? p.getFileName().toString() : "";
                    try {
                        if (TARGET_NAME.equals(fileName)) {
                            try (BufferedReader br = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                                String line;
                                while ((line = br.readLine()) != null) {
                                    lineHandler.accept(line);
                                }
                                break block15;
                            }
                        }
                        if (!fileName.toLowerCase().endsWith(".zip")) break block15;
                        try (ZipFile zf = new ZipFile(p.toFile());){
                            configScrapper.processZipFile(zf, lineHandler);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error processing path: " + String.valueOf(p), e);
                    }
                }
            });
        }
    }

    private static void processZipFile(ZipFile zf, Consumer<String> lineHandler) throws IOException {
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = configScrapper.getSimpleName(entry.getName());
            if (TARGET_NAME.equals(entryName)) {
                InputStream is = zf.getInputStream(entry);
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            lineHandler.accept(line);
                        }
                        continue;
                    }
                    finally {
                        br.close();
                        continue;
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    continue;
                }
            }
            if (!entry.getName().toLowerCase().endsWith(".zip")) continue;
            InputStream nestedIs = zf.getInputStream(entry);
            try {
                byte[] nestedBytes = configScrapper.toByteArray(nestedIs);
                try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(nestedBytes));){
                    configScrapper.processZipInputStream(zis, lineHandler);
                }
            }
            finally {
                if (nestedIs == null) continue;
                nestedIs.close();
            }
        }
    }

    private static void processZipInputStream(ZipInputStream zis, Consumer<String> lineHandler) throws IOException {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                zis.closeEntry();
                continue;
            }
            String entryName = configScrapper.getSimpleName(entry.getName());
            if (TARGET_NAME.equals(entryName)) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        lineHandler.accept(line);
                    }
                }
            } else if (entry.getName().toLowerCase().endsWith(".zip")) {
                byte[] nestedBytes = configScrapper.toByteArray(zis);
                try (ZipInputStream nestedZis = new ZipInputStream(new ByteArrayInputStream(nestedBytes));){
                    configScrapper.processZipInputStream(nestedZis, lineHandler);
                }
            } else {
                byte[] buffer = new byte[8192];
                while (zis.read(buffer) > 0) {
                }
            }
            zis.closeEntry();
        }
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int r;
            byte[] buf = new byte[8192];
            while ((r = is.read(buf)) != -1) {
                baos.write(buf, 0, r);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static String getSimpleName(String entryName) {
        if (entryName == null) {
            return "";
        }
        int slash = Math.max(entryName.lastIndexOf(47), entryName.lastIndexOf(92));
        return slash >= 0 ? entryName.substring(slash + 1) : entryName;
    }
}

