/*
 * Decompiled with CFR 0.152.
 */
package Wind.tensuraaifix;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="tensuraaifix")
@Mod.EventBusSubscriber(modid="tensuraaifix", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TensuraAIFixMod {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean VERBOSE_LOGGING = false;
    private static final List<String> TARGET_NAMESPACES = Arrays.asList("tensura", "tensura_neb");
    private static final Set<String> SKIP_ENTITIES = Set.of("giant_salmon", "giant_cod", "spear_toro", "hover_lizard", "landfish");
    private static final Set<String> CLONE_IDS = Set.of("clone_default", "clone");
    private static final Set<String> EXEMPT_PASSIVE_MELEE = Set.of("orc_lord");
    private static final int MELEE_RECALC_TICKS = 10;
    private static final Map<MinecraftServer, Integer> fixedMobCount = new HashMap<MinecraftServer, Integer>();
    private static final Map<MinecraftServer, Integer> tickCounter = new HashMap<MinecraftServer, Integer>();
    private static final Set<String> warnedEntities = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> SESSION_FIXED = ConcurrentHashMap.newKeySet();
    private static final String TENSURA_PASSIVE_MELEE_FQCN = "com.github.manasmods.tensura.api.entity.ai.PassiveMeleeAttackGoal";

    public TensuraAIFixMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("[TensuraAIFix] Mod loaded successfully!");
        event.getServer().m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)"[TensuraAIFix] Mod loaded successfully!")));
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        fixedMobCount.putIfAbsent(server, 0);
        tickCounter.put(server, 0);
        if (server.m_129792_()) {
            server.m_6846_().m_11314_().forEach(p -> p.m_213846_((Component)Component.m_237113_((String)"\u00a7d[TensuraAIFix] Running in Singleplayer Mode!")));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        int count = tickCounter.merge(server, 1, Integer::sum);
        if (count == 200) {
            int fixed = fixedMobCount.getOrDefault(server, 0);
            Object msg = fixed > 0 ? "\u00a7b[TensuraAIFix] Fixed " + fixed + " Tensura mob AIs!" : "\u00a7e[TensuraAIFix] No Tensura mobs found to fix yet.";
            server.m_6846_().m_11314_().forEach(arg_0 -> TensuraAIFixMod.lambda$onServerTick$2((String)msg, arg_0));
            if (fixed > 0) {
                LOGGER.info("[TensuraAIFix] Fixed {} Tensura mob AIs total.", (Object)fixed);
            }
        }
        if (server.m_129921_() % 40 == 0) {
            int budget = 256;
            block0: for (ServerLevel level : server.m_129785_()) {
                if (budget <= 0) break;
                for (PathfinderMob mob : level.m_45976_(PathfinderMob.class, level.m_6857_().m_61946_().m_83215_())) {
                    if (budget-- <= 0) continue block0;
                    ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
                    if (rl == null || !TARGET_NAMESPACES.contains(rl.m_135827_()) || SKIP_ENTITIES.contains(rl.m_135815_()) || CLONE_IDS.contains(rl.m_135815_()) || EXEMPT_PASSIVE_MELEE.contains(rl.m_135815_())) continue;
                    TensuraAIFixMod.scrubPassiveMeleeOnly(mob);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (rl == null) {
            return;
        }
        if (!TARGET_NAMESPACES.contains(rl.m_135827_())) {
            return;
        }
        if (SKIP_ENTITIES.contains(rl.m_135815_())) {
            return;
        }
        if (!SESSION_FIXED.add(mob.m_20148_())) {
            return;
        }
        if (mob.getPersistentData().m_128471_("tensuraaifix:ai_fixed")) {
            return;
        }
        boolean changed = false;
        if (CLONE_IDS.contains(rl.m_135815_())) {
            mob.m_21557_(true);
            changed = true;
        } else if (EXEMPT_PASSIVE_MELEE.contains(rl.m_135815_())) {
            changed |= TensuraAIFixMod.ensureOrcLordPredation(mob);
            changed |= TensuraAIFixMod.ensureOrcLordMelee(mob);
        } else {
            boolean isFlying = mob.m_21573_() instanceof FlyingPathNavigation;
            changed |= TensuraAIFixMod.scrubPassiveMeleeOnly(mob);
            if (!isFlying) {
                changed |= TensuraAIFixMod.replaceMeleeWithThrottled(mob);
            }
            if (mob instanceof Monster) {
                changed |= TensuraAIFixMod.ensureBasicTargeting((Monster)mob);
            }
        }
        if (changed) {
            TensuraAIFixMod.markFixed(level, mob);
        }
    }

    private static void markFixed(Level level, PathfinderMob mob) {
        mob.getPersistentData().m_128379_("tensuraaifix:ai_fixed", true);
        MinecraftServer srv = level.m_7654_();
        if (srv != null) {
            fixedMobCount.put(srv, fixedMobCount.getOrDefault(srv, 0) + 1);
        }
    }

    private static boolean scrubPassiveMeleeOnly(PathfinderMob mob) {
        boolean removed = false;
        try {
            String cn;
            Goal g;
            for (WrappedGoal wg : new ArrayList(mob.f_21345_.m_148105_())) {
                g = wg.m_26015_();
                cn = g.getClass().getName();
                if (!TENSURA_PASSIVE_MELEE_FQCN.equals(cn) && !"PassiveMeleeAttackGoal".equals(g.getClass().getSimpleName())) continue;
                mob.f_21345_.m_25363_(g);
                removed = true;
            }
            for (WrappedGoal wg : new ArrayList(mob.f_21346_.m_148105_())) {
                g = wg.m_26015_();
                cn = g.getClass().getName();
                if (!TENSURA_PASSIVE_MELEE_FQCN.equals(cn) && !"PassiveMeleeAttackGoal".equals(g.getClass().getSimpleName())) continue;
                mob.f_21346_.m_25363_(g);
                removed = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return removed;
    }

    private static boolean replaceMeleeWithThrottled(PathfinderMob mob) {
        boolean hadVanilla = false;
        try {
            for (WrappedGoal wg : new ArrayList(mob.f_21345_.m_148105_())) {
                Goal g = wg.m_26015_();
                if (g instanceof ThrottledMeleeAttackGoal) {
                    return false;
                }
                if (!(g instanceof MeleeAttackGoal)) continue;
                hadVanilla = true;
                mob.f_21345_.m_25363_(g);
            }
            if (hadVanilla) {
                mob.f_21345_.m_25352_(2, (Goal)new ThrottledMeleeAttackGoal(mob, 1.0, true, 10));
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean ensureBasicTargeting(Monster mob) {
        boolean hasNearestPlayer = false;
        boolean hasHurtBy = false;
        try {
            for (WrappedGoal wg : mob.f_21346_.m_148105_()) {
                Goal g = wg.m_26015_();
                String name = g.getClass().getSimpleName();
                if (name.contains("NearestAttackableTargetGoal")) {
                    hasNearestPlayer = true;
                }
                if (name.contains("HurtByTargetGoal")) {
                    hasHurtBy = true;
                }
                if (!hasNearestPlayer || !hasHurtBy) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean changed = false;
        if (!hasHurtBy) {
            mob.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)mob, new Class[0]));
            changed = true;
        }
        if (!hasNearestPlayer) {
            mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)mob, Player.class, true));
            changed = true;
        }
        return changed;
    }

    private static boolean ensureOrcLordPredation(PathfinderMob mob) {
        Predicate<LivingEntity> preyFilter = e -> {
            Player p;
            if (e == mob || !e.m_6084_() || mob.m_7307_((Entity)e)) {
                return false;
            }
            if (e instanceof Player && ((p = (Player)e).m_7500_() || p.m_5833_())) {
                return false;
            }
            ResourceLocation erl = ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_());
            return erl == null || !"tensura".equals(erl.m_135827_()) || !erl.m_135815_().contains("orc");
        };
        mob.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(mob, new Class[0]));
        mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)mob, LivingEntity.class, 10, true, false, preyFilter));
        return true;
    }

    private static boolean ensureOrcLordMelee(PathfinderMob mob) {
        try {
            for (WrappedGoal wg : mob.f_21345_.m_148105_()) {
                if (!(wg.m_26015_() instanceof MeleeAttackGoal)) continue;
                return false;
            }
            mob.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal(mob, 1.2, true));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$onServerTick$2(String msg, ServerPlayer p) {
        p.m_213846_((Component)Component.m_237113_((String)msg));
    }

    public static class ThrottledMeleeAttackGoal
    extends MeleeAttackGoal {
        private final int recalcEveryTicks;
        private int cooldown = 0;

        public ThrottledMeleeAttackGoal(PathfinderMob mob, double speed, boolean longMemory, int recalcEveryTicks) {
            super(mob, speed, longMemory);
            this.recalcEveryTicks = Math.max(1, recalcEveryTicks);
        }

        public void m_8037_() {
            if (this.cooldown-- <= 0) {
                this.cooldown = this.recalcEveryTicks;
                super.m_8037_();
            }
        }
    }

    public static class SlowFollowPlayerGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speed;
        private final double followDistance;
        private int cooldown = 0;

        public SlowFollowPlayerGoal(PathfinderMob mob, double speed, double followDistance) {
            this.mob = mob;
            this.speed = speed;
            this.followDistance = followDistance;
        }

        public boolean m_8036_() {
            if (!this.mob.m_6084_()) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            Level level = this.mob.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.m_8795_(p -> p.m_20280_((Entity)this.mob) < this.followDistance * this.followDistance);
            return !players.isEmpty();
        }

        public void m_8056_() {
            Level level = this.mob.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.m_8795_(p -> p.m_20280_((Entity)this.mob) < this.followDistance * this.followDistance);
            if (!players.isEmpty()) {
                ServerPlayer target = (ServerPlayer)players.get(this.mob.m_217043_().m_188503_(players.size()));
                double dx = target.m_20185_() - this.mob.m_20185_();
                double dz = target.m_20189_() - this.mob.m_20189_();
                this.mob.m_21573_().m_26519_(this.mob.m_20185_() + dx * 0.1, this.mob.m_20186_(), this.mob.m_20189_() + dz * 0.1, this.speed);
            }
            this.cooldown = 20;
        }
    }
}

