/**
 * Copyright (c) 2022-2025 LinusDev
 * Author: Linusdev
 * Contact: linus@linusdev.de
 */

#ifndef SETTINGS_H
  #define SETTINGS_H


#define DISABLE_SHADOW_BLOCK_SIDE
#define SHADOW_COLOR_DAY VEC3(0.7)
#define SHADOW_COLOR_NIGHT SHADOW_COLOR_DAY
#define SHADOW_COLOR_CAVE SHADOW_COLOR_DAY
#define SHADOW_COLOR_NETHER VEC3(1.0)
#define SHADOW_COLOR_END VEC3(1.0)

#define SATURATION 1.0
#define DISABLE_TONE_MAPPING



#define TORCH_COLOR_DAY VEC3(0.6, 0.2, 0.04)
#define TORCH_COLOR_NIGHT TORCH_COLOR_DAY
#define TORCH_COLOR_CAVE TORCH_COLOR_DAY
#define TORCH_COLOR_NETHER TORCH_COLOR_DAY
#define TORCH_COLOR_END TORCH_COLOR_DAY

#define DISABLE_AMBIENT_LIGHT
#define DISABLE_VIGNETTE


#define DISABLE_MIX_ES_FOG_AND_MC_FOG

#define ES_FOG_MIN_DISTANCE (16.0 * 7.)
#define ES_FOG_END 1.05
#define ES_FOG_START 0.5
#define ES_FOG_START_MIX_WITH_MOJANG_FOG ES_FOG_START

#define ES_FOG_COLOR_DAY(MC_FOG_COLOR, CURR_RENDER_COLOR) (MC_FOG_COLOR)
#define ES_FOG_COLOR_NIGHT(MC_FOG_COLOR, CURR_RENDER_COLOR) (MC_FOG_COLOR)

#define ES_CAVE_FOG_END ES_FOG_END
#define ES_CAVE_FOG_START ES_FOG_START
#define ES_CAVE_FOG_START_MIX_WITH_MOJANG_FOG ES_FOG_START_MIX_WITH_MOJANG_FOG
#define ES_CAVE_FOG_COLOR(MC_FOG_COLOR, CURR_RENDER_COLOR) (MC_FOG_COLOR)


#define ES_NETHER_FOG_END 1.6
#define ES_NETHER_FOG_START 0.3
#define ES_NETHER_FOG_START_MIX_WITH_MOJANG_FOG ES_NETHER_FOG_START
#define ES_NETHER_FOG_COLOR(MC_FOG_COLOR, CURR_RENDER_COLOR) (MC_FOG_COLOR)

#define ES_END_FOG_END ES_FOG_END
#define ES_END_FOG_START ES_FOG_START
#define ES_END_FOG_START_MIX_WITH_MOJANG_FOG ES_FOG_START_MIX_WITH_MOJANG_FOG
#define ES_END_FOG_COLOR(MC_FOG_COLOR, CURR_RENDER_COLOR) (MC_FOG_COLOR)


#endif