/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.command.CommandBuilder;
import com.uravgcode.modernessentials.exception.RequiresPlayerException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public final class RepairCommand
implements CommandBuilder {
    private static final Component NOTHING_TO_REPAIR = Component.text((String)"nothing to repair", (TextColor)NamedTextColor.RED);
    private static final Component SUCCESSFULLY_REPAIRED = Component.text((String)"successfully repaired ", (TextColor)NamedTextColor.GREEN);

    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"repair").requires(this.permission("essentials.repair"))).then(Commands.literal((String)"hand").executes(this::repairHand))).then(Commands.literal((String)"all").executes(this::repairAll))).executes(this::repairHand)).build();
    }

    private int repairHand(CommandContext<CommandSourceStack> context) throws RequiresPlayerException {
        Player player = this.player(context);
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.repairItem(item)) {
            player.sendMessage(SUCCESSFULLY_REPAIRED.append(item.displayName()));
        } else {
            player.sendMessage(NOTHING_TO_REPAIR);
        }
        return 1;
    }

    private int repairAll(CommandContext<CommandSourceStack> context) throws RequiresPlayerException {
        Player player = this.player(context);
        ArrayList repairedItems = new ArrayList();
        player.getInventory().forEach(item -> {
            if (this.repairItem((ItemStack)item)) {
                repairedItems.add(item.displayName());
            }
        });
        if (repairedItems.isEmpty()) {
            player.sendMessage(NOTHING_TO_REPAIR);
        } else {
            player.sendMessage(SUCCESSFULLY_REPAIRED.append(Component.join((JoinConfiguration)JoinConfiguration.spaces(), repairedItems)));
        }
        return 1;
    }

    private boolean repairItem(@Nullable ItemStack item) {
        Damageable damageable;
        ItemMeta itemMeta;
        if (item != null && (itemMeta = item.getItemMeta()) instanceof Damageable && (damageable = (Damageable)itemMeta).hasDamage()) {
            damageable.setDamage(0);
            item.setItemMeta((ItemMeta)damageable);
            return true;
        }
        return false;
    }
}

