/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.ConfigModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.module.PluginModule;
import com.uravgcode.modernessentials.placeholder.Placeholders;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="join-quit")
public final class JoinQuitModule
extends PluginModule {
    private final MiniMessage miniMessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders(), Placeholders.audiencePlaceholders()})).build();
    @ConfigValue(path="join-quit.join-message")
    private String joinMessage = "<green>+ <player> <gray>Connected";
    @ConfigValue(path="join-quit.quit-message")
    private String quitMessage = "<red>- <player> <gray>Disconnected";

    public JoinQuitModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.joinMessage(this.miniMessage.deserialize(this.joinMessage, (Pointered)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        event.quitMessage(this.miniMessage.deserialize(this.quitMessage, (Pointered)event.getPlayer()));
    }
}

