/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.mute.MuteEvent;
import com.uravgcode.modernessentials.event.mute.UnmuteEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@CommandModule(name="mute")
public final class MuteModule
extends PluginModule {
    private final NamespacedKey muteKey;

    public MuteModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.muteKey = new NamespacedKey((Plugin)plugin, "mute");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onMute(MuteEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        dataContainer.set(this.muteKey, PersistentDataType.BYTE, (Object)1);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onUnmute(UnmuteEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        dataContainer.remove(this.muteKey);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.muteKey)) {
            event.setCancelled(true);
            player.sendMessage((Component)Component.translatable((String)"chat.cannotSend", (TextColor)NamedTextColor.RED));
        }
    }
}

