/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EnderChestCommand {
    public static void registerCommands(Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enderchest").requires(sender -> sender.getSender().hasPermission("essentials.enderchest"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).requires(sender -> sender.getSender().hasPermission("essentials.enderchest.others"))).suggests(EnderChestCommand::getPlayerSuggestions).executes(EnderChestCommand::openOtherEnderChest))).executes(EnderChestCommand::openEnderChest)).build());
    }

    private static int openEnderChest(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.openInventory(player.getEnderChest());
        }
        return 1;
    }

    private static int openOtherEnderChest(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        String targetName = (String)context.getArgument("player", String.class);
        Server server = ((CommandSourceStack)context.getSource()).getSender().getServer();
        Player target = server.getPlayer(targetName);
        if (target != null) {
            player.openInventory(target.getEnderChest());
        } else {
            player.sendMessage((Component)Component.translatable((String)"argument.entity.notfound.player", (TextColor)NamedTextColor.RED));
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> getPlayerSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Server server = ((CommandSourceStack)context.getSource()).getSender().getServer();
        server.getOnlinePlayers().stream().map(Player::getName).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

