/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class FlyCommand {
    public static final NamespacedKey FLY_KEY = new NamespacedKey("modern-essentials", "fly");

    public static void registerCommands(Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fly").requires(sender -> sender.getSender().hasPermission("essentials.fly"))).executes(FlyCommand::execute)).build());
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PersistentDataContainer dataContainer = player.getPersistentDataContainer();
            if (dataContainer.has(FLY_KEY)) {
                if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
                    player.setAllowFlight(false);
                    player.setFlying(false);
                }
                dataContainer.remove(FLY_KEY);
                player.sendMessage((Component)Component.text((String)"Fly mode disabled", (TextColor)NamedTextColor.RED));
            } else {
                player.setAllowFlight(true);
                player.setFlying(true);
                dataContainer.set(FLY_KEY, PersistentDataType.BYTE, (Object)1);
                player.sendMessage((Component)Component.text((String)"Fly mode enabled", (TextColor)NamedTextColor.GREEN));
            }
        }
        return 1;
    }
}

