/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class VanishCommand {
    public static final NamespacedKey VANISH_KEY = new NamespacedKey("modern-essentials", "vanish");

    public static void registerCommands(Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vanish").requires(sender -> sender.getSender().hasPermission("essentials.vanish"))).executes(VanishCommand::execute)).build());
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        Plugin plugin = ((CommandSourceStack)context.getSource()).getSender().getServer().getPluginManager().getPlugin("modern-essentials");
        if (plugin == null) {
            return 0;
        }
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PersistentDataContainer dataContainer = player.getPersistentDataContainer();
            if (dataContainer.has(VANISH_KEY)) {
                dataContainer.remove(VANISH_KEY);
                for (Player other : player.getServer().getOnlinePlayers()) {
                    other.showPlayer(plugin, player);
                    other.listPlayer(player);
                }
                player.sendMessage((Component)Component.text((String)"Vanish mode disabled", (TextColor)NamedTextColor.RED));
            } else {
                for (Player other : player.getServer().getOnlinePlayers()) {
                    other.hidePlayer(plugin, player);
                    other.unlistPlayer(player);
                }
                dataContainer.set(VANISH_KEY, PersistentDataType.BYTE, (Object)1);
                player.sendMessage((Component)Component.text((String)"Vanish mode enabled", (TextColor)NamedTextColor.GREEN));
            }
        }
        return 1;
    }
}

