/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.listener;

import com.uravgcode.modernessentials.placeholder.Placeholders;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ChatListener
implements Listener {
    private final JavaPlugin plugin;
    private MiniMessage miniMessage = MiniMessage.miniMessage();
    private String format = "";

    public ChatListener(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        event.renderer((player, playerName, message, viewer) -> this.miniMessage.deserialize(this.format, (Pointered)player, (TagResolver)Placeholder.component((String)"message", (ComponentLike)message)));
    }

    public void reload() {
        ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("chat");
        if (config == null) {
            return;
        }
        this.miniMessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders(), Placeholders.audiencePlaceholders()})).build();
        this.format = config.getString("format", "");
    }
}

