/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.listener;

import com.uravgcode.modernessentials.placeholder.Placeholders;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class JoinListener
implements Listener {
    private final JavaPlugin plugin;
    private MiniMessage minimessage = MiniMessage.miniMessage();
    private String headerString = "";
    private String footerString = "";
    private long refreshInterval = 20L;

    public JoinListener(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        player.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            Component header = this.minimessage.deserialize(this.headerString, (Pointered)player);
            Component footer = this.minimessage.deserialize(this.footerString, (Pointered)player);
            player.sendPlayerListHeaderAndFooter(header, footer);
        }, null, 1L, this.refreshInterval);
    }

    public void reload() {
        ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("tab-list");
        if (config == null) {
            return;
        }
        this.minimessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders(), Placeholders.audiencePlaceholders()})).build();
        this.headerString = String.join((CharSequence)"\n", config.getStringList("header"));
        this.footerString = String.join((CharSequence)"\n", config.getStringList("footer"));
        this.refreshInterval = config.getLong("refresh-interval", 20L);
    }
}

