/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.listener;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.uravgcode.modernessentials.placeholder.Placeholders;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PingListener
implements Listener {
    private final JavaPlugin plugin;
    private List<Component> motds = Collections.emptyList();
    private int maxPlayers = -1;
    private int fakePlayers = -1;
    private boolean hidePlayerCount = false;
    private boolean disablePlayerListHover = false;

    public PingListener(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onServerListPing(PaperServerListPingEvent event) {
        if (!this.motds.isEmpty()) {
            event.motd(this.motds.size() == 1 ? this.motds.getFirst() : this.motds.get(ThreadLocalRandom.current().nextInt(this.motds.size())));
        }
        if (this.maxPlayers >= 0) {
            event.setMaxPlayers(this.maxPlayers);
        }
        if (this.fakePlayers >= 0) {
            event.setNumPlayers(this.fakePlayers);
        }
        if (this.hidePlayerCount) {
            event.setHidePlayers(true);
        }
        if (this.disablePlayerListHover) {
            event.getListedPlayers().clear();
        }
    }

    public void reload() {
        ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("server-list");
        if (config == null) {
            return;
        }
        MiniMessage minimessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders()})).build();
        List motdStrings = config.getStringList("motd");
        this.motds = motdStrings.stream().map(arg_0 -> ((MiniMessage)minimessage).deserialize(arg_0)).toList();
        this.maxPlayers = config.getInt("max-players", -1);
        this.fakePlayers = config.getInt("fake-players", -1);
        this.hidePlayerCount = config.getBoolean("hide-player-count", false);
        this.disablePlayerListHover = config.getBoolean("disable-player-list-hover", false);
    }
}

