/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.listener;

import com.uravgcode.modernessentials.command.VanishCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public record VanishListener(@NotNull JavaPlugin plugin) implements Listener
{
    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isVanished(player)) {
            event.joinMessage(null);
            for (Player other : player.getServer().getOnlinePlayers()) {
                other.hidePlayer((Plugin)this.plugin, player);
                other.unlistPlayer(player);
            }
        } else {
            for (Player other : player.getServer().getOnlinePlayers()) {
                if (!this.isVanished(other)) continue;
                player.hidePlayer((Plugin)this.plugin, other);
                player.unlistPlayer(other);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoinGod(PlayerQuitEvent event) {
        if (this.isVanished(event.getPlayer())) {
            event.quitMessage(null);
        }
    }

    private boolean isVanished(Player player) {
        return player.getPersistentDataContainer().has(VanishCommand.VANISH_KEY) && player.hasPermission("essentials.vanish");
    }
}

