/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.placeholder;

import io.github.miniplaceholders.api.MiniPlaceholders;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class Placeholders {
    private static final TagResolver internalGlobalPlaceholders = TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholders.globalPlaceholder("online", () -> Component.text((int)Bukkit.getOnlinePlayers().size())), Placeholders.globalPlaceholder("online_max", () -> Component.text((int)Bukkit.getMaxPlayers())), TagResolver.resolver((String)"time", (arguments, context) -> {
        String format = arguments.popOr("format expected").value();
        return Tag.inserting((Component)context.deserialize(DateTimeFormatter.ofPattern(format).format(LocalDateTime.now())));
    })});
    private static final TagResolver internalAudiencePlaceholders = TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholders.audiencePlaceholder("player", Player::getName), Placeholders.audiencePlaceholder("displayname", Player::displayName), Placeholders.audiencePlaceholder("uuid", OfflinePlayer::getUniqueId), Placeholders.audiencePlaceholder("ping", Player::getPing), Placeholders.audiencePlaceholder("health", Damageable::getHealth), Placeholders.audiencePlaceholder("world", player -> player.getWorld().getName())});

    private Placeholders() {
    }

    public static TagResolver globalPlaceholders() {
        try {
            return TagResolver.resolver((TagResolver[])new TagResolver[]{MiniPlaceholders.audiencePlaceholders(), internalGlobalPlaceholders});
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            return internalGlobalPlaceholders;
        }
    }

    public static TagResolver audiencePlaceholders() {
        try {
            return TagResolver.resolver((TagResolver[])new TagResolver[]{MiniPlaceholders.audiencePlaceholders(), internalAudiencePlaceholders});
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            return internalAudiencePlaceholders;
        }
    }

    private static TagResolver globalPlaceholder(@TagPattern @NotNull String name, @NotNull Supplier<Component> supplier) {
        return TagResolver.resolver((String)name, (arguments, context) -> Tag.inserting((Component)((Component)supplier.get())));
    }

    private static TagResolver audiencePlaceholder(@TagPattern @NotNull String name, @NotNull Function<Player, ?> handler) {
        return TagResolver.resolver((String)name, (arguments, context) -> {
            TextComponent textComponent;
            Player player = (Player)context.targetAsType(Player.class);
            Object result = handler.apply(player);
            if (result instanceof Component) {
                Component component = (Component)result;
                textComponent = component;
            } else {
                textComponent = Component.text((String)String.valueOf(result));
            }
            TextComponent content = textComponent;
            return Tag.inserting((Component)content);
        });
    }
}

