/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.uravgcode.modernessentials.command.BaseCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RepairCommand
implements BaseCommand {
    private static final Component NOTHING_TO_REPAIR = Component.text((String)"nothing to repair", (TextColor)NamedTextColor.RED);
    private static final Component SUCCESSFULLY_REPAIRED = Component.text((String)"successfully repaired ", (TextColor)NamedTextColor.GREEN);

    @Override
    public void register(@NotNull Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"repair").requires(this.playerPermission("essentials.repair"))).then(Commands.literal((String)"hand").executes(RepairCommand::repairHand))).then(Commands.literal((String)"all").executes(RepairCommand::repairAll))).executes(RepairCommand::repairHand)).build());
    }

    private static int repairHand(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (RepairCommand.repairItem(item)) {
            player.sendMessage(SUCCESSFULLY_REPAIRED.append(item.displayName()));
        } else {
            player.sendMessage(NOTHING_TO_REPAIR);
        }
        return 1;
    }

    private static int repairAll(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ArrayList repairedItems = new ArrayList();
        player.getInventory().forEach(item -> {
            if (RepairCommand.repairItem(item)) {
                repairedItems.add(item.displayName());
            }
        });
        if (repairedItems.isEmpty()) {
            player.sendMessage(NOTHING_TO_REPAIR);
        } else {
            player.sendMessage(SUCCESSFULLY_REPAIRED.append(Component.join((JoinConfiguration)JoinConfiguration.spaces(), repairedItems)));
        }
        return 1;
    }

    private static boolean repairItem(@Nullable ItemStack item) {
        Damageable damageable;
        ItemMeta itemMeta;
        if (item != null && (itemMeta = item.getItemMeta()) instanceof Damageable && (damageable = (Damageable)itemMeta).hasDamage()) {
            damageable.setDamage(0);
            item.setItemMeta((ItemMeta)damageable);
            return true;
        }
        return false;
    }
}

