/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.uravgcode.modernessentials.ModernEssentials;
import com.uravgcode.modernessentials.command.BaseCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class TimeCommand
implements BaseCommand {
    @Override
    public void register(@NotNull Commands registrar) {
        Map<String, Long> times = Map.of("day", 1000L, "night", 13000L, "noon", 6000L, "midnight", 18000L, "sunrise", 23000L, "sunset", 12000L);
        times.forEach((name, time) -> registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).requires(this.permission("essentials.time"))).executes(context -> TimeCommand.setTime((CommandContext<CommandSourceStack>)context, time))).build()));
    }

    private static int setTime(CommandContext<CommandSourceStack> context, long time) {
        ModernEssentials plugin = ModernEssentials.instance();
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Server server = sender.getServer();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        World world = executor != null ? executor.getWorld() : server.getRespawnWorld();
        sender.sendMessage((Component)Component.translatable((String)"commands.time.set", (ComponentLike[])new ComponentLike[]{Component.text((long)time)}));
        server.getGlobalRegionScheduler().execute((Plugin)plugin, () -> world.setTime(time));
        return 1;
    }
}

