/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.uravgcode.modernessentials.ModernEssentials;
import com.uravgcode.modernessentials.command.BaseCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class VanishCommand
implements BaseCommand {
    public static final NamespacedKey VANISH_KEY = new NamespacedKey("modern-essentials", "vanish");

    @Override
    public void register(@NotNull Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vanish").requires(this.playerPermission("essentials.vanish"))).executes(VanishCommand::execute)).build());
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        ModernEssentials plugin = ModernEssentials.instance();
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        Collection onlinePlayers = player.getServer().getOnlinePlayers();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(VANISH_KEY)) {
            player.setInvisible(false);
            onlinePlayers.forEach(other -> {
                other.showPlayer((Plugin)plugin, player);
                other.listPlayer(player);
            });
            dataContainer.remove(VANISH_KEY);
            player.sendMessage((Component)Component.text((String)"Vanish mode disabled", (TextColor)NamedTextColor.RED));
        } else {
            player.setInvisible(true);
            onlinePlayers.forEach(other -> {
                other.hidePlayer((Plugin)plugin, player);
                other.unlistPlayer(player);
            });
            dataContainer.set(VANISH_KEY, PersistentDataType.BYTE, (Object)1);
            player.sendMessage((Component)Component.text((String)"Vanish mode enabled", (TextColor)NamedTextColor.GREEN));
        }
        return 1;
    }
}

