/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.uravgcode.modernessentials.ModernEssentials;
import com.uravgcode.modernessentials.command.BaseCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class WeatherCommand
implements BaseCommand {
    @Override
    public void register(@NotNull Commands registrar) {
        Map<String, Command> weathers = Map.of("sun", context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, false, false, "commands.weather.set.clear"), "rain", context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, true, false, "commands.weather.set.rain"), "thunder", context -> WeatherCommand.setWeather((CommandContext<CommandSourceStack>)context, true, true, "commands.weather.set.thunder"));
        weathers.forEach((name, executor) -> registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).requires(this.permission("essentials.weather"))).executes(executor)).build()));
    }

    private static int setWeather(CommandContext<CommandSourceStack> context, boolean storm, boolean thunder, @NotNull String key) {
        ModernEssentials plugin = ModernEssentials.instance();
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Server server = sender.getServer();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        World world = executor != null ? executor.getWorld() : server.getRespawnWorld();
        sender.sendMessage((Component)Component.translatable((String)key));
        server.getGlobalRegionScheduler().execute((Plugin)plugin, () -> {
            world.setStorm(storm);
            world.setThundering(thunder);
        });
        return 1;
    }
}

