/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.command.FlyCommand;
import com.uravgcode.modernessentials.module.PluginModule;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class FlyModule
extends PluginModule {
    public FlyModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.shouldEnableFlight(player)) {
            this.enableFlight(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (this.shouldEnableFlight(player)) {
            this.enableFlight(player);
        }
    }

    private void enableFlight(Player player) {
        player.getScheduler().run((Plugin)this.plugin, task -> {
            player.setAllowFlight(true);
            player.setFlying(true);
        }, null);
    }

    private boolean shouldEnableFlight(Player player) {
        return player.getPersistentDataContainer().has(FlyCommand.FLY_KEY) && player.hasPermission("essentials.fly");
    }
}

