/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.command.GodCommand;
import com.uravgcode.modernessentials.module.PluginModule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class GodModule
extends PluginModule {
    public GodModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        HumanEntity player;
        Entity entity = event.getEntity();
        if (entity instanceof HumanEntity && this.isGod(player = (HumanEntity)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (this.isGod(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    private boolean isGod(HumanEntity player) {
        return player.getPersistentDataContainer().has(GodCommand.GOD_KEY) && player.hasPermission("essentials.god");
    }
}

