/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.module.PluginModule;
import com.uravgcode.modernessentials.placeholder.Placeholders;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class TabListModule
extends PluginModule {
    private final MiniMessage miniMessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders(), Placeholders.audiencePlaceholders()})).build();
    @ConfigValue(name="tab-list.format")
    private String format = "<player>";
    @ConfigValue(name="tab-list.header")
    private String headerString = "";
    @ConfigValue(name="tab-list.footer")
    private String footerString = "";
    @ConfigValue(name="tab-list.refresh-interval")
    private long refreshInterval = 20L;

    public TabListModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        player.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            Component name = this.miniMessage.deserialize(this.format, (Pointered)player);
            Component header = this.miniMessage.deserialize(this.headerString, (Pointered)player);
            Component footer = this.miniMessage.deserialize(this.footerString, (Pointered)player);
            player.playerListName(name);
            player.sendPlayerListHeaderAndFooter(header, footer);
        }, null, 1L, this.refreshInterval);
    }
}

