/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.command.VanishCommand;
import com.uravgcode.modernessentials.module.PluginModule;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class VanishModule
extends PluginModule {
    public VanishModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Collection onlinePlayers = player.getServer().getOnlinePlayers();
        if (this.isVanished(player)) {
            event.joinMessage(null);
            player.setInvisible(true);
            onlinePlayers.forEach(other -> {
                other.hidePlayer((Plugin)this.plugin, player);
                other.unlistPlayer(player);
            });
        } else {
            player.setInvisible(false);
            onlinePlayers.forEach(other -> {
                if (this.isVanished((Player)other)) {
                    player.hidePlayer((Plugin)this.plugin, other);
                    player.unlistPlayer(other);
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.isVanished(event.getPlayer())) {
            event.quitMessage(null);
        }
    }

    private boolean isVanished(Player player) {
        return player.getPersistentDataContainer().has(VanishCommand.VANISH_KEY) && player.hasPermission("essentials.vanish");
    }
}

