/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.registry;

import com.google.common.reflect.ClassPath;
import com.uravgcode.modernessentials.command.BaseCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Predicate;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;

public final class CommandRegistrar {
    private CommandRegistrar() {
    }

    public static void registerAll(@NotNull @NotNull ReloadableRegistrarEvent<@NotNull Commands> commands, @NotNull ComponentLogger logger) {
        try {
            ClassLoader loader = CommandRegistrar.class.getClassLoader();
            ClassPath classPath = ClassPath.from((ClassLoader)loader);
            String packageName = "com.uravgcode.modernessentials.command";
            List<Class> classes = classPath.getTopLevelClasses("com.uravgcode.modernessentials.command").stream().map(ClassPath.ClassInfo::load).filter(BaseCommand.class::isAssignableFrom).filter(Predicate.not(Class::isInterface)).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).toList();
            int count = 0;
            for (Class clazz2 : classes) {
                try {
                    BaseCommand command = clazz2.asSubclass(BaseCommand.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    command.register((Commands)commands.registrar());
                    ++count;
                }
                catch (Exception ignored) {
                    logger.warn("Failed to register {}", (Object)clazz2.getSimpleName());
                }
            }
            logger.info("Registered {} commands", (Object)count);
        }
        catch (IOException exception) {
            logger.error("Failed to register commands");
        }
    }
}

