/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.registry;

import com.google.common.reflect.ClassPath;
import com.uravgcode.modernessentials.module.PluginModule;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ModuleRegistrar {
    private static final List<@NotNull PluginModule> modules = new ArrayList<PluginModule>();

    private ModuleRegistrar() {
    }

    public static void registerAll(@NotNull JavaPlugin plugin) {
        ComponentLogger logger = plugin.getComponentLogger();
        try {
            ClassLoader loader = plugin.getClass().getClassLoader();
            ClassPath classPath = ClassPath.from((ClassLoader)loader);
            String packageName = "com.uravgcode.modernessentials.module";
            List<Class> classes = classPath.getTopLevelClasses("com.uravgcode.modernessentials.module").stream().map(ClassPath.ClassInfo::load).filter(PluginModule.class::isAssignableFrom).filter(Predicate.not(Class::isInterface)).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).toList();
            for (Class clazz2 : classes) {
                try {
                    PluginModule module = clazz2.asSubclass(PluginModule.class).getConstructor(JavaPlugin.class).newInstance(plugin);
                    plugin.getServer().getPluginManager().registerEvents((Listener)module, (Plugin)plugin);
                    modules.add(module);
                }
                catch (Exception ignored) {
                    logger.warn("Failed to register {}", (Object)clazz2.getSimpleName());
                }
            }
            logger.info("Registered {} modules", (Object)modules.size());
        }
        catch (IOException exception) {
            logger.error("Failed to register modules");
        }
    }

    public static void reloadAll() {
        modules.forEach(PluginModule::reload);
    }
}

