/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.exception.RequiresPlayerException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface CommandBuilder {
    public LiteralCommandNode<CommandSourceStack> build();

    @NotNull
    default public Predicate<CommandSourceStack> permission(@NotNull String permission) {
        return source -> source.getSender().hasPermission(permission);
    }

    @NotNull
    default public Player player(@NotNull CommandContext<CommandSourceStack> context) throws RequiresPlayerException {
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            return player;
        }
        throw new RequiresPlayerException();
    }
}

