/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.ConfigModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.module.PluginModule;
import java.util.Collections;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="command-whitelist")
public final class CommandWhitelistModule
extends PluginModule {
    private static final String permission = "essentials.commandwhitelist.bypass";
    @ConfigValue(path="command-whitelist.whitelist")
    private Set<String> whitelist = Collections.emptySet();

    public CommandWhitelistModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (event.getPlayer().hasPermission(permission)) {
            return;
        }
        event.getCommands().removeIf(command -> !this.whitelist.contains(command));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission(permission)) {
            return;
        }
        String message = event.getMessage();
        String command = message.substring(1);
        String literal = command.split(" ")[0];
        if (this.whitelist.contains(literal)) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.translatable((String)"command.unknown.command"), Component.newline(), Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)command), Component.translatable((String)"command.context.here")}).clickEvent(ClickEvent.suggestCommand((String)message))}).color((TextColor)NamedTextColor.RED));
    }
}

