/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.GodEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@CommandModule(name="god")
public final class GodModule
extends PluginModule {
    private final NamespacedKey godKey;

    public GodModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.godKey = new NamespacedKey((Plugin)plugin, "god");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onGod(GodEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.godKey)) {
            dataContainer.remove(this.godKey);
            player.sendMessage((Component)Component.text((String)"God mode disabled", (TextColor)NamedTextColor.RED));
        } else {
            player.setHealth(20.0);
            player.setFoodLevel(20);
            dataContainer.set(this.godKey, PersistentDataType.BYTE, (Object)1);
            player.sendMessage((Component)Component.text((String)"God mode enabled", (TextColor)NamedTextColor.GREEN));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        HumanEntity player;
        Entity entity = event.getEntity();
        if (entity instanceof HumanEntity && this.isGod(player = (HumanEntity)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (this.isGod(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    private boolean isGod(@NotNull HumanEntity player) {
        return player.getPersistentDataContainer().has(this.godKey) && player.hasPermission("essentials.god");
    }
}

