/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.annotation.ConfigModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class PluginModule
implements Listener {
    protected final JavaPlugin plugin;
    protected boolean enabled;

    protected PluginModule(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.enabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        ComponentLogger logger = this.plugin.getComponentLogger();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigValue.class)) continue;
            ConfigValue annotation = field.getAnnotation(ConfigValue.class);
            String path = annotation.path();
            try {
                field.setAccessible(true);
                Object value = config.get(path, field.get(this));
                field.set(this, PluginModule.convert(value, field.getType()));
            }
            catch (Exception exception) {
                logger.warn("failed to inject config value for {}: {}", (Object)field.getName(), (Object)exception.getMessage());
            }
            finally {
                field.setAccessible(false);
            }
        }
        boolean enabled = true;
        if (this.getClass().isAnnotationPresent(ConfigModule.class)) {
            ConfigModule annotation = this.getClass().getAnnotation(ConfigModule.class);
            enabled = config.getBoolean(annotation.path() + ".enabled", false);
        } else if (this.getClass().isAnnotationPresent(CommandModule.class)) {
            CommandModule annotation = this.getClass().getAnnotation(CommandModule.class);
            boolean bl = enabled = this.plugin.getServer().getCommandMap().getCommand(annotation.name()) != null;
        }
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
    }

    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @NotNull
    private static Object convert(@NotNull Object value, @NotNull Class<?> type) {
        Object object;
        Set set = value;
        Objects.requireNonNull(set);
        Set set2 = set;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, List.class, String.class}, (Object)set2, n)) {
                case 0: {
                    List list = (List)((Object)set2);
                    if (type != String.class) {
                        n = 1;
                        continue block5;
                    }
                    object = list.stream().map(Object::toString).collect(Collectors.joining("\n"));
                    break block5;
                }
                case 1: {
                    List list = (List)((Object)set2);
                    if (type != Set.class) {
                        n = 2;
                        continue block5;
                    }
                    object = Set.copyOf(list);
                    break block5;
                }
                case 2: {
                    String string = (String)((Object)set2);
                    if (type != List.class) {
                        n = 3;
                        continue block5;
                    }
                    object = List.of(string);
                    break block5;
                }
                default: {
                    object = value;
                    break block5;
                }
            }
            break;
        }
        return object;
    }
}

