/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.VanishEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@CommandModule(name="vanish")
public final class VanishModule
extends PluginModule {
    private final NamespacedKey vanishKey;

    public VanishModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.vanishKey = new NamespacedKey((Plugin)plugin, "vanish");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVanish(VanishEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.vanishKey)) {
            this.showPlayer(player);
            dataContainer.remove(this.vanishKey);
            player.sendMessage((Component)Component.text((String)"Vanish mode disabled", (TextColor)NamedTextColor.RED));
        } else {
            this.hidePlayer(player);
            dataContainer.set(this.vanishKey, PersistentDataType.BYTE, (Object)1);
            player.sendMessage((Component)Component.text((String)"Vanish mode enabled", (TextColor)NamedTextColor.GREEN));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isVanished(player)) {
            this.hidePlayer(player);
            event.joinMessage(null);
        } else {
            this.hideVanishedPlayers(player);
            player.setInvisible(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.isVanished(event.getPlayer())) {
            event.quitMessage(null);
        }
    }

    private void hideVanishedPlayers(@NotNull Player player) {
        for (Player other : player.getServer().getOnlinePlayers()) {
            if (!this.isVanished(other)) continue;
            player.hidePlayer((Plugin)this.plugin, other);
            player.unlistPlayer(other);
        }
    }

    private void hidePlayer(@NotNull Player player) {
        player.setInvisible(true);
        for (Player other : player.getServer().getOnlinePlayers()) {
            other.hidePlayer((Plugin)this.plugin, player);
            other.unlistPlayer(player);
        }
    }

    private void showPlayer(@NotNull Player player) {
        player.setInvisible(false);
        for (Player other : player.getServer().getOnlinePlayers()) {
            other.showPlayer((Plugin)this.plugin, player);
            other.listPlayer(player);
        }
    }

    private boolean isVanished(@NotNull Player player) {
        return player.getPersistentDataContainer().has(this.vanishKey) && player.hasPermission("essentials.vanish");
    }
}

