/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.command.CommandBuilder;
import com.uravgcode.modernessentials.exception.NoPlayerFoundException;
import com.uravgcode.modernessentials.exception.RequiresPlayerException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class HealCommand
implements CommandBuilder {
    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"heal").requires(this.permission("essentials.heal"))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)ArgumentTypes.players()).requires(this.permission("essentials.heal.others"))).executes(this::healOthers))).executes(this::heal)).build();
    }

    private int heal(CommandContext<CommandSourceStack> context) throws RequiresPlayerException {
        Player player = this.player(context);
        AttributeInstance attribute = player.getAttribute(Attribute.MAX_HEALTH);
        if (attribute != null) {
            double health = player.getHealth();
            double maxHealth = attribute.getValue();
            player.heal(maxHealth - health);
            player.sendMessage(Component.text((String)"Healed ").append(player.name()));
        }
        return 1;
    }

    private int healOthers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("targets", PlayerSelectorArgumentResolver.class);
        List targets = (List)targetResolver.resolve((CommandSourceStack)context.getSource());
        if (targets.isEmpty()) {
            throw new NoPlayerFoundException();
        }
        for (Player target : targets) {
            AttributeInstance attribute = target.getAttribute(Attribute.MAX_HEALTH);
            if (attribute == null) continue;
            double health = target.getHealth();
            double maxHealth = attribute.getValue();
            target.heal(maxHealth - health);
        }
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (targets.size() == 1) {
            sender.sendMessage(Component.text((String)"Healed ").append(((Player)targets.getFirst()).name()));
        } else {
            sender.sendMessage((Component)Component.text((String)("Healed " + targets.size() + " players")));
        }
        return 1;
    }
}

