/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command.mute;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.command.CommandBuilder;
import com.uravgcode.modernessentials.event.mute.MuteEvent;
import com.uravgcode.modernessentials.exception.NoPlayerFoundException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;

public final class MuteCommand
implements CommandBuilder {
    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mute").requires(this.permission("essentials.mute"))).then(Commands.argument((String)"targets", (ArgumentType)ArgumentTypes.players()).executes(this::execute))).build();
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("targets", PlayerSelectorArgumentResolver.class);
        List targets = (List)targetResolver.resolve((CommandSourceStack)context.getSource());
        if (targets.isEmpty()) {
            throw new NoPlayerFoundException();
        }
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        PluginManager pluginManager = sender.getServer().getPluginManager();
        for (Player target : targets) {
            pluginManager.callEvent((Event)new MuteEvent(target));
        }
        if (targets.size() == 1) {
            sender.sendMessage(Component.text((String)"Muted ").append(((Player)targets.getFirst()).name()));
        } else {
            sender.sendMessage((Component)Component.text((String)("Muted " + targets.size() + " players")));
        }
        return 1;
    }
}

