/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.NicknameEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@CommandModule(name="nickname")
public final class NicknameModule
extends PluginModule
implements PacketListener {
    private static final Map<UUID, String> nicknames = new ConcurrentHashMap<UUID, String>();
    private final PacketListenerCommon packetListener = this.asAbstract(PacketListenerPriority.HIGH);
    private final NamespacedKey nicknameKey;

    public NicknameModule(JavaPlugin plugin) {
        super(plugin);
        this.nicknameKey = new NamespacedKey((Plugin)plugin, "nickname");
    }

    public static Component nickname(@NotNull Player player) {
        String nickname = nicknames.get(player.getUniqueId());
        if (nickname == null) {
            return player.name().hoverEvent((HoverEventSource)player);
        }
        return Component.text((String)nickname).hoverEvent((HoverEventSource)player);
    }

    @Override
    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            PacketEvents.getAPI().getEventManager().registerListener(this.packetListener);
        }
    }

    @Override
    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            HandlerList.unregisterAll((Listener)this);
            PacketEvents.getAPI().getEventManager().unregisterListener(this.packetListener);
        }
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.PLAYER_INFO_UPDATE) {
            return;
        }
        WrapperPlayServerPlayerInfoUpdate wrapper = new WrapperPlayServerPlayerInfoUpdate(event);
        for (WrapperPlayServerPlayerInfoUpdate.PlayerInfo playerInfo : wrapper.getEntries()) {
            UserProfile profile = playerInfo.getGameProfile();
            String nickname = nicknames.get(profile.getUUID());
            if (nickname == null) continue;
            profile.setName(nickname);
            event.markForReEncode(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onNick(NicknameEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        String nickname = event.getNickname();
        if (nickname == null) {
            nicknames.remove(uuid);
            dataContainer.remove(this.nicknameKey);
        } else {
            nicknames.put(uuid, nickname);
            dataContainer.set(this.nicknameKey, PersistentDataType.STRING, (Object)nickname);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.nicknameKey, PersistentDataType.STRING)) {
            nicknames.put(player.getUniqueId(), (String)dataContainer.get(this.nicknameKey, PersistentDataType.STRING));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        nicknames.remove(event.getPlayer().getUniqueId());
    }
}

