/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.uravgcode.modernessentials.annotation.ConfigModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.module.PluginModule;
import com.uravgcode.modernessentials.placeholder.Placeholders;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="server-list")
public final class ServerListModule
extends PluginModule {
    private final MiniMessage miniMessage;
    @ConfigValue(path="server-list.motd")
    private List<String> motds = Collections.emptyList();
    @ConfigValue(path="server-list.max-players")
    private int maxPlayers = -1;
    @ConfigValue(path="server-list.fake-players")
    private int fakePlayers = -1;
    @ConfigValue(path="server-list.hide-player-count")
    private boolean hidePlayerCount = false;
    @ConfigValue(path="server-list.disable-player-list-hover")
    private boolean disablePlayerListHover = false;

    public ServerListModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.miniMessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders()})).build();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onServerListPing(PaperServerListPingEvent event) {
        if (!this.motds.isEmpty()) {
            Component motd = this.motds.size() == 1 ? this.miniMessage.deserialize((Object)this.motds.getFirst()) : this.miniMessage.deserialize((Object)this.motds.get(ThreadLocalRandom.current().nextInt(this.motds.size())));
            event.motd(motd);
        }
        if (this.maxPlayers >= 0) {
            event.setMaxPlayers(this.maxPlayers);
        }
        if (this.fakePlayers >= 0) {
            event.setNumPlayers(this.fakePlayers);
        }
        if (this.hidePlayerCount) {
            event.setHidePlayers(true);
        }
        if (this.disablePlayerListHover) {
            event.getListedPlayers().clear();
        }
    }
}

