/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.text.BookContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextBookComponent
extends BookComponent<Config> {
    public TextBookComponent() {
        super(Config.CODEC);
    }

    @Override
    public int getTotalHeight(Config config, BookContext context) {
        return context.getFont().split((FormattedText)config.text().toComponent(), config.width()).size() * config.lineHeight() + config.offset() + config.extraHeight();
    }

    @Override
    public void render(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
        List list = context.getFont().split((FormattedText)config.text().toComponent(), config.width());
        for (int i = 0; i < list.size(); ++i) {
            int renderY = y + config.offset() + i * config.lineHeight();
            float alpha = Math.abs((float)renderY - ((float)(context.getContentY() - context.getBookDefinition().frameWidth()) + 0.5f * (float)context.getBookDefinition().height())) / (0.5f * (float)context.getBookDefinition().height() - (float)context.getBookDefinition().frameWidth());
            graphics.drawString(context.getFont(), (FormattedCharSequence)list.get(i), x, renderY, FastColor.ARGB32.colorFromFloat((float)Mth.clamp((float)(1.2f - alpha), (float)0.1f, (float)1.0f), (float)0.0f, (float)0.0f, (float)0.0f), true);
        }
    }

    @Override
    public void onClick(Config config, BookContext context, int x, int y) {
        List list = context.getFont().split((FormattedText)config.text().toComponent(), config.width());
        int line = (context.getMouseY() - (y + config.offset())) / config.lineHeight();
        if (context.getMouseY() >= y + config.offset() && line >= 0 && line < list.size()) {
            ClickEvent event;
            Style style;
            FormattedCharSequence charSequence = (FormattedCharSequence)list.get(line);
            int width = context.getFont().width(charSequence);
            if (context.getMouseX() >= x && context.getMouseX() <= x + width && (style = context.getFont().getSplitter().componentStyleAtWidth(charSequence, context.getMouseX() - x)) != null && (event = style.getClickEvent()) != null && event.getAction() == ClickEvent.Action.CHANGE_PAGE) {
                context.jumpToComponent(ResourceLocation.parse((String)event.getValue()));
            }
        }
    }

    public record Config(ResourceLocation id, HashSet<HashSet<ResourceLocation>> unlockConditions, BookContent text, int offset, int extraHeight, int width, int lineHeight) implements BookComponentConfig
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(Config::id), (App)ResourceLocation.CODEC.listOf().xmap(Sets::newHashSet, Lists::newArrayList).listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("unlock_conditions").forGetter(Config::unlockConditions), (App)BookContent.CODEC.fieldOf("text").forGetter(Config::text), (App)Codec.INT.fieldOf("offset").forGetter(Config::offset), (App)Codec.INT.fieldOf("extra_height").forGetter(Config::extraHeight), (App)Codec.INT.fieldOf("width").forGetter(Config::width), (App)Codec.INT.fieldOf("line_height").forGetter(Config::lineHeight)).apply((Applicative)instance, Config::new));
    }
}

