/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.YetiAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Yeti;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class YetiModel<T extends Yeti>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("yeti"), "main");
    private final ModelPart root;
    private final ModelPart eye;
    private final ModelPart fur;
    private final ModelPart body;

    public YetiModel(ModelPart root) {
        this.root = root.getChild("root");
        this.fur = root.getChild("root").getChild("head").getChild("fur");
        this.body = root.getChild("root").getChild("head").getChild("body");
        this.eye = root.getChild("root").getChild("head").getChild("eye");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)2.0f, (float)1.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)2.0f, (float)1.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)5.0f, (float)-2.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(31, 0).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)-1.0f));
        head.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -10.0f, -4.4f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        head.addOrReplaceChild("body", CubeListBuilder.create().texOffs(2, 1).addBox(-5.0f, -16.0f, -1.0f, 9.0f, 13.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(9, 8).addBox(-5.0f, -16.0f, -2.0f, 9.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("fur", CubeListBuilder.create().texOffs(0, 34).addBox(-6.0f, -16.0f, -1.0f, 11.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(8, 42).addBox(-6.0f, -16.0f, -2.0f, 11.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.fur.visible = ((Yeti)((Object)entity)).hasFur();
        this.body.visible = !((Yeti)((Object)entity)).hasFur();
        this.animate(((Yeti)((Object)entity)).idleAnimationState, YetiAnimation.IDLE, ageInTicks);
        if (((Yeti)((Object)entity)).getRollState() != 2) {
            this.animateWalk(YetiAnimation.WALK, limbSwing, limbSwingAmount, this.young ? 3.0f : 5.0f, 1.0f);
        }
        this.root.xRot = 0.0f;
        if (this.young) {
            this.root.xScale = 0.8f;
            this.root.yScale = 0.8f;
            this.root.zScale = 0.8f;
        }
        switch (((Yeti)((Object)entity)).getRollState()) {
            case 1: {
                this.animate(((Yeti)((Object)entity)).rollStartAnimationState, YetiAnimation.ROLL_START, ageInTicks);
                float rollAngle = Mth.rotLerp((float)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), (float)((Yeti)((Object)entity)).prevRollAngle, (float)((Yeti)((Object)entity)).rollAngle);
                this.root.xRot = rollAngle * ((float)Math.PI / 180);
                break;
            }
            case 2: {
                this.animate(((Yeti)((Object)entity)).rollAnimationState, YetiAnimation.ROLL, ageInTicks);
                float rollAngle = Mth.rotLerp((float)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()), (float)((Yeti)((Object)entity)).prevRollAngle, (float)((Yeti)((Object)entity)).rollAngle);
                this.root.xRot = rollAngle * ((float)Math.PI / 180);
                break;
            }
            case 3: {
                this.animate(((Yeti)((Object)entity)).rollEndAnimationState, YetiAnimation.ROLL_END, ageInTicks);
                float progress = Math.min(10.0f, (float)((Yeti)((Object)entity)).rollEndAnimationState.getAccumulatedTime() / 1000.0f * 20.0f) / 10.0f;
                float rollAngle = Mth.rotLerp((float)progress, (float)((Yeti)((Object)entity)).rollAngle, (float)0.0f);
                this.root.xRot = rollAngle * ((float)Math.PI / 180);
            }
        }
        Entity camera = Minecraft.getInstance().getCameraEntity();
        if (camera != null) {
            Vec3 targetEyePos = camera.getEyePosition(0.0f);
            Vec3 yetiEyePos = entity.getEyePosition(0.0f);
            this.eye.y = targetEyePos.y > yetiEyePos.y ? (this.eye.y += -1.0f) : (this.eye.y += 0.0f);
            Vec3 vec33 = entity.getViewVector(0.0f);
            vec33 = new Vec3(vec33.x, 0.0, vec33.z);
            Vec3 vec34 = new Vec3(yetiEyePos.x - targetEyePos.x, 0.0, yetiEyePos.z - targetEyePos.z).normalize().yRot(1.5707964f);
            double e = vec33.dot(vec34);
            this.eye.x += Mth.sqrt((float)((float)Math.abs(e))) * 2.0f * (float)Math.signum(e);
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

