/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.environment;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MeteorParticle
extends Particle {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private final TrailEffect effect = new TrailEffect(0.8f, 15);

    protected MeteorParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.xd = 0.0;
        this.yd = -2.0;
        this.zd = 0.0;
        this.lifetime = 400;
    }

    public void tick() {
        super.tick();
        this.level.addParticle((ParticleOptions)ESExplosionParticleOptions.AETHERSENT, true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        this.effect.update(new Vec3(this.xo, this.yo, this.zo));
        if (this.onGround) {
            this.effect.setLength(Math.max(this.effect.getLength() - 0.75f, 0.0f));
            if (this.effect.getLength() <= 0.0f) {
                this.remove();
            }
        }
        this.xd = 0.0;
        this.yd = -2.0;
        this.zd = 0.0;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        PoseStack stack = new PoseStack();
        float x = (float)Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x);
        float y = (float)Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
        float z = (float)Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z);
        stack.pushPose();
        stack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
        this.effect.prepareRender(new Vec3((double)x, (double)y, (double)z), partialTicks);
        this.effect.render(ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE)), stack, 0.5647059f, 0.36862746f, 0.65882355f, 2.0f, 0xF000F0);
        stack.popPose();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new MeteorParticle(level, x, y, z);
        }
    }
}

