/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.world;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ESSkyRenderer {
    private static final ResourceLocation DEAD_STAR_LOCATION = EternalStarlight.id("textures/environment/dead_star.png");
    private static final float TIME = 12500.0f;
    private static final float FIXED_TIME = (float)(Mth.frac((double)0.27083333333333337) * 2.0 + 0.5 - Math.cos(Mth.frac((double)0.27083333333333337) * Math.PI) / 2.0) / 3.0f;
    private static VertexBuffer starBuffer;

    public static boolean renderSky(ClientLevel level, Matrix4f modelViewMatrix, Matrix4f matrix, float partialTicks, Camera camera, Runnable setupFog) {
        FogType fogType;
        Minecraft minecraft = Minecraft.getInstance();
        LevelRenderer levelRenderer = minecraft.levelRenderer;
        setupFog.run();
        if (starBuffer == null) {
            ESSkyRenderer.createStars();
        }
        if ((fogType = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogType != FogType.LAVA && !levelRenderer.doesMobEffectBlockSky(camera)) {
            float l;
            float j;
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(modelViewMatrix);
            Vec3 vec3 = level.getSkyColor(minecraft.gameRenderer.getMainCamera().getPosition(), partialTicks);
            float g = (float)vec3.x;
            float h = (float)vec3.y;
            float i = (float)vec3.z;
            FogRenderer.levelFogColor();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)g, (float)h, (float)i, (float)1.0f);
            ShaderInstance shaderInstance = RenderSystem.getShader();
            levelRenderer.skyBuffer.bind();
            levelRenderer.skyBuffer.drawWithShader(poseStack.last().pose(), matrix, shaderInstance);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            float[] fs = level.effects().getSunriseColor(FIXED_TIME, partialTicks);
            if (fs != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.pushPose();
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                j = Mth.sin((float)level.getSunAngle(partialTicks)) < 0.0f ? 180.0f : 0.0f;
                poseStack.mulPose(Axis.ZP.rotationDegrees(j));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                float k = fs[0];
                l = fs[1];
                float m = fs[2];
                Matrix4f matrix4f3 = poseStack.last().pose();
                BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                bufferBuilder.addVertex(matrix4f3, 0.0f, 100.0f, 0.0f).setColor(k, l, m, fs[3]);
                for (int o = 0; o <= 16; ++o) {
                    float p = (float)o * ((float)Math.PI * 2) / 16.0f;
                    float q = Mth.sin((float)p);
                    float r = Mth.cos((float)p);
                    bufferBuilder.addVertex(matrix4f3, q * 120.0f, r * 120.0f, -r * 40.0f * fs[3]).setColor(fs[0], fs[1], fs[2], 0.0f);
                }
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                poseStack.popPose();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.pushPose();
            float rainLevel = level.getRainLevel(partialTicks);
            if (ClientWeatherState.weather != null) {
                rainLevel = ClientWeatherState.weather.modifyRainLevel(rainLevel);
            } else {
                ClientWeatherState.levelTarget = rainLevel;
                rainLevel = ClientWeatherState.getRainLevel(partialTicks);
            }
            j = 1.0f - rainLevel;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)j);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(FIXED_TIME * 360.0f));
            Matrix4f matrix4f4 = poseStack.last().pose();
            l = 60.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DEAD_STAR_LOCATION);
            BufferBuilder bufferBuilder2 = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder2.addVertex(matrix4f4, -l, 100.0f, -l).setUv(0.0f, 0.0f);
            bufferBuilder2.addVertex(matrix4f4, l, 100.0f, -l).setUv(1.0f, 0.0f);
            bufferBuilder2.addVertex(matrix4f4, l, 100.0f, l).setUv(1.0f, 1.0f);
            bufferBuilder2.addVertex(matrix4f4, -l, 100.0f, l).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder2.buildOrThrow());
            float v = 1.0f;
            RenderSystem.setShaderColor((float)v, (float)v, (float)v, (float)v);
            FogRenderer.setupNoFog();
            starBuffer.bind();
            starBuffer.drawWithShader(poseStack.last().pose(), matrix, GameRenderer.getPositionShader());
            VertexBuffer.unbind();
            setupFog.run();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.popPose();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    private static void createStars() {
        if (starBuffer != null) {
            starBuffer.close();
        }
        starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        starBuffer.bind();
        starBuffer.upload(ESSkyRenderer.drawStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private static MeshData drawStars(Tesselator tesselator) {
        RandomSource randomSource = RandomSource.create((long)10842L);
        float f = 100.0f;
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int j = 0; j < 3000; ++j) {
            float g = randomSource.nextFloat() * 2.0f - 1.0f;
            float h = randomSource.nextFloat() * 2.0f - 1.0f;
            float k = randomSource.nextFloat() * 2.0f - 1.0f;
            float l = 0.15f + randomSource.nextFloat() * 0.1f;
            float m = Mth.lengthSquared((float)g, (float)h, (float)k);
            if (m <= 0.010000001f || m >= 1.0f) continue;
            Vector3f vector3f = new Vector3f(g, h, k).normalize(100.0f);
            float n = (float)(randomSource.nextDouble() * 3.1415927410125732 * 2.0);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(n);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, -l, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, l, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, l, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, -l, 0.0f).rotate((Quaternionfc)quaternionf)));
        }
        return bufferBuilder.buildOrThrow();
    }
}

