/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESTemplatePools;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.world.gen.structure.StranghoulDenStructure;
import cn.leolezury.eternalstarlight.common.world.gen.structure.garden.CursedGardenStructure;
import cn.leolezury.eternalstarlight.common.world.gen.structure.placement.AvoidLandmarkStructurePlacement;
import cn.leolezury.eternalstarlight.common.world.gen.structure.placement.LandmarkStructurePlacement;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class ESStructures {
    public static final ResourceKey<Structure> PORTAL_RUINS_COMMON = ESStructures.create("portal_ruins_common");
    public static final ResourceKey<StructureSet> PORTAL_RUINS_COMMON_SET = ESStructures.createSet("portal_ruins_common");
    public static final ResourceKey<Structure> PORTAL_RUINS_FOREST = ESStructures.create("portal_ruins_forest");
    public static final ResourceKey<StructureSet> PORTAL_RUINS_FOREST_SET = ESStructures.createSet("portal_ruins_forest");
    public static final ResourceKey<Structure> PORTAL_RUINS_DESERT = ESStructures.create("portal_ruins_desert");
    public static final ResourceKey<StructureSet> PORTAL_RUINS_DESERT_SET = ESStructures.createSet("portal_ruins_desert");
    public static final ResourceKey<Structure> PORTAL_RUINS_JUNGLE = ESStructures.create("portal_ruins_jungle");
    public static final ResourceKey<StructureSet> PORTAL_RUINS_JUNGLE_SET = ESStructures.createSet("portal_ruins_jungle");
    public static final ResourceKey<Structure> PORTAL_RUINS_COLD = ESStructures.create("portal_ruins_cold");
    public static final ResourceKey<StructureSet> PORTAL_RUINS_COLD_SET = ESStructures.createSet("portal_ruins_cold");
    public static final ResourceKey<Structure> GOLEM_FORGE = ESStructures.create("golem_forge");
    public static final ResourceKey<StructureSet> GOLEM_FORGE_SET = ESStructures.createSet("golem_forge");
    public static final ResourceKey<Structure> CURSED_GARDEN = ESStructures.create("cursed_garden");
    public static final ResourceKey<StructureSet> CURSED_GARDEN_SET = ESStructures.createSet("cursed_garden");
    public static final ResourceKey<Structure> STRANGHOUL_DEN = ESStructures.create("stranghoul_den");
    public static final ResourceKey<StructureSet> STRANGHOUL_DEN_SET = ESStructures.createSet("stranghoul_den");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter poolGetter = context.lookup(Registries.TEMPLATE_POOL);
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        context.register(PORTAL_RUINS_COMMON, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_PORTAL_RUINS_COMMON), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)poolGetter.getOrThrow(ESTemplatePools.PORTAL_RUINS_COMMON), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 50, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(PORTAL_RUINS_FOREST, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_PORTAL_RUINS_FOREST), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)poolGetter.getOrThrow(ESTemplatePools.PORTAL_RUINS_FOREST), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 50, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(PORTAL_RUINS_DESERT, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_PORTAL_RUINS_DESERT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)poolGetter.getOrThrow(ESTemplatePools.PORTAL_RUINS_DESERT), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 50, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(PORTAL_RUINS_JUNGLE, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_PORTAL_RUINS_JUNGLE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)poolGetter.getOrThrow(ESTemplatePools.PORTAL_RUINS_JUNGLE), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 50, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(PORTAL_RUINS_COLD, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_PORTAL_RUINS_COLD), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)poolGetter.getOrThrow(ESTemplatePools.PORTAL_RUINS_COLD), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 50, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(GOLEM_FORGE, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_GOLEM_FORGE), Map.of(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)poolGetter.getOrThrow(ESTemplatePools.GOLEM_FORGE_BOSS), Optional.empty(), 20, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)48)), false, Optional.empty(), 116, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
        context.register(CURSED_GARDEN, (Object)new CursedGardenStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_CURSED_GARDEN), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN)));
        context.register(STRANGHOUL_DEN, (Object)new StranghoulDenStructure(new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(ESTags.Biomes.HAS_STRANGHOUL_DEN), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
    }

    public static void bootstrapSets(BootstrapContext<StructureSet> context) {
        HolderGetter structureGetter = context.lookup(Registries.STRUCTURE);
        context.register(PORTAL_RUINS_COMMON_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(PORTAL_RUINS_COMMON), (StructurePlacement)new RandomSpreadStructurePlacement(36, 30, RandomSpreadType.LINEAR, 958853901)));
        context.register(PORTAL_RUINS_FOREST_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(PORTAL_RUINS_FOREST), (StructurePlacement)new RandomSpreadStructurePlacement(36, 30, RandomSpreadType.LINEAR, 789224182)));
        context.register(PORTAL_RUINS_DESERT_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(PORTAL_RUINS_DESERT), (StructurePlacement)new RandomSpreadStructurePlacement(36, 30, RandomSpreadType.LINEAR, 525823926)));
        context.register(PORTAL_RUINS_JUNGLE_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(PORTAL_RUINS_JUNGLE), (StructurePlacement)new RandomSpreadStructurePlacement(36, 30, RandomSpreadType.LINEAR, 391037419)));
        context.register(PORTAL_RUINS_COLD_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(PORTAL_RUINS_COLD), (StructurePlacement)new RandomSpreadStructurePlacement(36, 30, RandomSpreadType.LINEAR, 107391749)));
        context.register(GOLEM_FORGE_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(GOLEM_FORGE), (StructurePlacement)new LandmarkStructurePlacement(GOLEM_FORGE)));
        context.register(CURSED_GARDEN_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(CURSED_GARDEN), (StructurePlacement)new LandmarkStructurePlacement(CURSED_GARDEN)));
        context.register(STRANGHOUL_DEN_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(STRANGHOUL_DEN), (StructurePlacement)new AvoidLandmarkStructurePlacement(20, 8, RandomSpreadType.LINEAR, 615391630)));
    }

    public static ResourceKey<Structure> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)EternalStarlight.id(name));
    }

    public static ResourceKey<StructureSet> createSet(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)EternalStarlight.id(name));
    }
}

