/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimPattern;

public class ESTrimPatterns {
    public static final ResourceKey<TrimPattern> KEEPER = ESTrimPatterns.create("keeper");
    public static final ResourceKey<TrimPattern> FORGE = ESTrimPatterns.create("forge");
    public static final ResourceKey<TrimPattern> BLOOMING = ESTrimPatterns.create("blooming");
    public static final ResourceKey<TrimPattern> TWINING = ESTrimPatterns.create("twining");
    public static final List<ResourceKey<TrimPattern>> TRIM_PATTERNS = List.of(KEEPER, FORGE, BLOOMING, TWINING);

    public static void bootstrap(BootstrapContext<TrimPattern> context) {
        ESTrimPatterns.register(context, ESItems.KEEPER_ARMOR_TRIM_SMITHING_TEMPLATE.get(), KEEPER);
        ESTrimPatterns.register(context, ESItems.FORGE_ARMOR_TRIM_SMITHING_TEMPLATE.get(), FORGE);
        ESTrimPatterns.register(context, ESItems.BLOOMING_ARMOR_TRIM_SMITHING_TEMPLATE.get(), BLOOMING);
        ESTrimPatterns.register(context, ESItems.TWINING_ARMOR_TRIM_SMITHING_TEMPLATE.get(), TWINING);
    }

    private static void register(BootstrapContext<TrimPattern> context, Item item, ResourceKey<TrimPattern> resourceKey) {
        TrimPattern trimPattern = new TrimPattern(resourceKey.location(), BuiltInRegistries.ITEM.wrapAsHolder((Object)item), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)resourceKey.location())), false);
        context.register(resourceKey, (Object)trimPattern);
    }

    public static ResourceKey<TrimPattern> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)EternalStarlight.id(name));
    }
}

