/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.entity.attack.ray.LunarMonstrosityBreath;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class LunarMonstrosityToxicBreathPhase
extends BehaviorPhase<LunarMonstrosity> {
    public static final int ID = 1;

    public LunarMonstrosityToxicBreathPhase() {
        super(1, 1, 100, 200);
    }

    @Override
    public boolean canStart(LunarMonstrosity entity, boolean cooldownOver) {
        return cooldownOver && entity.getTarget() != null && entity.getPhase() == 1;
    }

    @Override
    public void onStart(LunarMonstrosity entity) {
    }

    @Override
    public void tick(LunarMonstrosity entity) {
        Level level;
        if (entity.getBehaviorTicks() == 20) {
            LunarMonstrosityBreath breath = new LunarMonstrosityBreath((EntityType<? extends LunarMonstrosityBreath>)ESEntities.LUNAR_MONSTROSITY_BREATH.get(), entity.level(), (LivingEntity)entity, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.5f), entity.getZ(), entity.yHeadRot + 90.0f, -entity.getXRot());
            entity.level().addFreshEntity((Entity)breath);
        }
        if (entity.getBehaviorTicks() >= 20 && entity.getBehaviorTicks() % 20 == 0 && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ScreenShakeVfx.createInstance((ResourceKey<Level>)entity.level().dimension(), entity.position(), 45.0f, 25, 0.24f, 0.24f, 4.5f, 5.0f).send(serverLevel);
        }
    }

    @Override
    public boolean canContinue(LunarMonstrosity entity) {
        return true;
    }

    @Override
    public void onStop(LunarMonstrosity entity) {
    }
}

