/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.npc.trade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class DyedArmorTrade
implements VillagerTrades.ItemListing {
    private final Item item;
    private final ItemStack currency;
    private final int maxUses;

    public DyedArmorTrade(Item item, Item currency, int currencyCount) {
        this(item, new ItemStack((ItemLike)currency, currencyCount), 12);
    }

    public DyedArmorTrade(Item item, ItemStack currency, int maxUses) {
        this.item = item;
        this.currency = currency;
        this.maxUses = maxUses;
    }

    public MerchantOffer getOffer(Entity entity, RandomSource randomSource) {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        if (stack.is(ItemTags.DYEABLE)) {
            ArrayList list = Lists.newArrayList();
            list.add(DyedArmorTrade.getRandomDye(randomSource));
            if (randomSource.nextFloat() > 0.7f) {
                list.add(DyedArmorTrade.getRandomDye(randomSource));
            }
            if (randomSource.nextFloat() > 0.8f) {
                list.add(DyedArmorTrade.getRandomDye(randomSource));
            }
            stack = DyedItemColor.applyDyes((ItemStack)stack, (List)list);
        }
        return new MerchantOffer(new ItemCost((ItemLike)this.currency.getItem(), this.currency.getCount()), stack, this.maxUses, 0, 0.0f);
    }

    private static DyeItem getRandomDye(RandomSource randomSource) {
        return DyeItem.byColor((DyeColor)DyeColor.byId((int)randomSource.nextInt(16)));
    }
}

