/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.magic;

import cn.leolezury.eternalstarlight.common.block.ESPortalBlock;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.network.OpenCrestGuiPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class OrbOfProphecyItem
extends Item {
    public OrbOfProphecyItem(Item.Properties properties) {
        super(properties);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int i) {
        if (livingEntity.getPose() != Pose.STANDING) {
            livingEntity.stopUsingItem();
        }
        if (!level.isClientSide && !itemStack.has(ESDataComponents.CURRENT_CREST.get()) && livingEntity.getTicksUsingItem() >= 140 && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ESPlatform.INSTANCE.sendToClient(player, new OpenCrestGuiPacket(ESCrestUtil.getCrests((Player)player), ESCrestUtil.getOwnedCrests((Player)player)));
            player.stopUsingItem();
            player.getCooldowns().addCooldown((Item)this, 20);
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (player.getPose() == Pose.STANDING) {
            Crest crest;
            Holder component;
            if (!itemStack.has(ESDataComponents.CURRENT_CREST.get())) {
                player.startUsingItem(interactionHand);
                return InteractionResultHolder.consume((Object)itemStack);
            }
            if (!level.isClientSide && player instanceof SpellCaster && !ESDataAttachments.SPELL_CAST_DATA.getData((Entity)player).hasSpell() && (component = (Holder)itemStack.get(ESDataComponents.CURRENT_CREST.get())) != null && component.isBound() && (crest = (Crest)component.value()).getSpell().isPresent() && crest.getSpell().get().canCast((LivingEntity)player, true)) {
                ESDataAttachments.SPELL_SOURCE.setData((Entity)player, new SpellCastData.ItemSpellSource(this, interactionHand));
                crest.getSpell().get().start((LivingEntity)player, ESCrestUtil.getCrestLevel(player, (Holder<Crest>)component), true);
                return InteractionResultHolder.consume((Object)itemStack);
            }
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        Player player = useOnContext.getPlayer();
        BlockPos pos = useOnContext.getClickedPos();
        if (level.getBlockState(pos).is(ESTags.Blocks.PORTAL_FRAME_BLOCKS) && (level.dimension() == ESDimensions.STARLIGHT_KEY || level.dimension() == Level.OVERWORLD) && ESPortalBlock.validateAndPlacePortal((LevelAccessor)level, pos)) {
            level.playSound(player, pos, SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

