/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.item.misc.Accessory;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class ESAccessoryUtil {
    public static Set<Item> getActiveAccessoriesOnArmors(LivingEntity entity) {
        return ESAccessoryUtil.getActiveAccessories(entity, Set.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET));
    }

    public static Set<Item> getActiveAccessories(LivingEntity entity, Set<EquipmentSlot> slots) {
        HashSet<Item> result = new HashSet<Item>();
        for (EquipmentSlot slot : slots) {
            result.addAll(ESAccessoryUtil.getAccessories(entity.getItemBySlot(slot)));
        }
        return result;
    }

    public static Set<Item> getAccessories(ItemStack stack) {
        return ((List)stack.getOrDefault(ESDataComponents.ACCESSORIES.get(), List.of())).stream().map(ItemStack::getItem).collect(Collectors.toSet());
    }

    public static int getAccessorySlotCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(ESDataComponents.ACCESSORY_SLOT_COUNT.get(), (Object)1);
    }

    public static void applyAccessory(ItemStack equipmentStack, ItemStack accessoryStack) {
        if (accessoryStack.isEmpty()) {
            return;
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        Accessory data = (Accessory)accessoryStack.get(ESDataComponents.ACCESSORY.get());
        ItemAttributeModifiers accessoryModifiers = data != null ? data.attributeModifiers() : ItemAttributeModifiers.EMPTY;
        for (EquipmentSlotGroup slotGroup : EquipmentSlotGroup.values()) {
            equipmentStack.forEachModifier(slotGroup, (attribute, modifier) -> builder.add(attribute, modifier, slotGroup));
        }
        for (ItemAttributeModifiers.Entry entry : accessoryModifiers.modifiers()) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        equipmentStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)builder.build());
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>((Collection)equipmentStack.getOrDefault(ESDataComponents.ACCESSORIES.get(), List.of()));
        accessories.add(accessoryStack.copyWithCount(1));
        equipmentStack.set(ESDataComponents.ACCESSORIES.get(), Collections.unmodifiableList(accessories));
    }

    public static void removeAccessory(ItemStack equipmentStack, ItemStack accessoryStack) {
        Accessory data = (Accessory)accessoryStack.get(ESDataComponents.ACCESSORY.get());
        ItemAttributeModifiers accessoryModifiers = data != null ? data.attributeModifiers() : ItemAttributeModifiers.EMPTY;
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)equipmentStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        ArrayList<ItemAttributeModifiers.Entry> entries = new ArrayList<ItemAttributeModifiers.Entry>(modifiers.modifiers());
        entries.removeIf(entry -> accessoryModifiers.modifiers().stream().anyMatch(e -> entry.modifier().id().equals((Object)e.modifier().id())));
        equipmentStack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(Collections.unmodifiableList(entries), modifiers.showInTooltip()));
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>((Collection)equipmentStack.getOrDefault(ESDataComponents.ACCESSORIES.get(), List.of()));
        accessories.removeIf(stack -> stack.getItem() == accessoryStack.getItem());
        equipmentStack.set(ESDataComponents.ACCESSORIES.get(), Collections.unmodifiableList(accessories));
    }

    public static boolean overrideEquipmentOnAccessory(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        List accessories = (List)stack.getOrDefault(ESDataComponents.ACCESSORIES.get(), List.of());
        ItemStack slotItem = slot.getItem();
        Accessory accessory = (Accessory)slotItem.get(ESDataComponents.ACCESSORY.get());
        if (accessories.isEmpty() && accessory == null) {
            return false;
        }
        if (slotItem.isEmpty()) {
            if (!accessories.isEmpty()) {
                ItemStack removed = (ItemStack)accessories.getLast();
                ESAccessoryUtil.removeAccessory(stack, removed);
                ItemStack remain = slot.safeInsert(removed.copy());
                ESAccessoryUtil.applyAccessory(stack, remain);
            }
        } else if (accessory != null && stack.is(accessory.combinationTarget()) && ESAccessoryUtil.getAccessorySlotCount(stack) > accessories.size() && accessories.stream().noneMatch(s -> s.getItem() == slotItem.getItem())) {
            ItemStack taken = slot.safeTake(slotItem.getCount(), 1, player);
            ESAccessoryUtil.applyAccessory(stack, taken);
        }
        return true;
    }

    public static boolean overrideAccessoryOnEquipment(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        Accessory accessory = (Accessory)other.get(ESDataComponents.ACCESSORY.get());
        if (!other.isEmpty() && accessory == null) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            List accessories = (List)stack.getOrDefault(ESDataComponents.ACCESSORIES.get(), List.of());
            if (other.isEmpty()) {
                if (!accessories.isEmpty()) {
                    ItemStack removed = (ItemStack)accessories.getLast();
                    ESAccessoryUtil.removeAccessory(stack, removed);
                    access.set(removed.copy());
                }
            } else if (accessory != null && stack.is(accessory.combinationTarget()) && ESAccessoryUtil.getAccessorySlotCount(stack) > accessories.size() && accessories.stream().noneMatch(s -> s.getItem() == other.getItem())) {
                ESAccessoryUtil.applyAccessory(stack, other);
                other.shrink(1);
            }
            return true;
        }
        return false;
    }
}

