/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.HorizontalAxisBlock;
import cn.leolezury.eternalstarlight.common.block.RedstoneDoomedenKeyholeBlock;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DoomedenKeyholeBlock
extends HorizontalAxisBlock {
    public static final MapCodec<DoomedenKeyholeBlock> CODEC = DoomedenKeyholeBlock.simpleCodec(DoomedenKeyholeBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public DoomedenKeyholeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.X));
    }

    protected MapCodec<DoomedenKeyholeBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)blockPlaceContext.getHorizontalDirection().getAxis());
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (itemStack.is(ESTags.Items.DOOMEDEN_KEYS) && !((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(blockPos, (Block)this, 15);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.getBlockState(fromPos).getBlock() instanceof RedstoneDoomedenKeyholeBlock && !((Boolean)state.getValue((Property)LIT)).booleanValue() && Arrays.stream(Direction.values()).anyMatch(direction -> this.hasInputSignal(level, pos, (Direction)direction))) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
            level.scheduleTick(pos, (Block)this, 15);
        }
    }

    protected boolean hasInputSignal(Level level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        int i = level.getSignal(blockPos, direction);
        if (i >= 15) {
            return true;
        }
        BlockState blockState = level.getBlockState(blockPos);
        return Math.max(i, blockState.is(Blocks.REDSTONE_WIRE) ? (Integer)blockState.getValue((Property)RedStoneWireBlock.POWER) : 0) > 0;
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            if (blockState.getValue((Property)AXIS) == Direction.Axis.X) {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (!serverLevel.getBlockState(blockPos.offset(0, i, j)).is(ESTags.Blocks.DOOMEDEN_KEYHOLE_DESTROYABLES)) continue;
                        serverLevel.destroyBlock(blockPos.offset(0, i, j), false, null);
                    }
                }
            } else {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (!serverLevel.getBlockState(blockPos.offset(i, j, 0)).is(ESTags.Blocks.DOOMEDEN_KEYHOLE_DESTROYABLES)) continue;
                        serverLevel.destroyBlock(blockPos.offset(i, j, 0), false, null);
                    }
                }
            }
            serverLevel.destroyBlock(blockPos, false, null);
        }
    }

    public boolean isSignalSource(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LIT);
    }

    public int getSignal(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return (Boolean)blockState.getValue((Property)LIT) != false ? 15 : super.getSignal(blockState, blockGetter, blockPos, direction);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }
}

