/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.golem.AstralGolem;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.golem.AstralGolemMaterial;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AstralGolemModel<T extends AstralGolem>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("astral_golem"), "main");
    public static final ModelLayerLocation INNER_ARMOR_LOCATION = new ModelLayerLocation(EternalStarlight.id("astral_golem"), "inner_armor");
    public static final ModelLayerLocation OUTER_ARMOR_LOCATION = new ModelLayerLocation(EternalStarlight.id("astral_golem"), "outer_armor");
    private float armXRot = 0.0f;
    private int tintColor = -1;

    public AstralGolemModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)26.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)26.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        AstralGolemMaterial material = ((AstralGolem)((Object)entity)).getMaterial();
        int n = this.tintColor = material == null ? -1 : material.tintColor();
        if (entity.getMainHandItem().isEmpty()) {
            this.leftArm.xRot += this.armXRot;
            this.rightArm.xRot += this.armXRot;
        } else {
            this.rightArm.xRot = this.rightArm.xRot - 1.57f - this.armXRot;
        }
        this.head.y += 12.0f;
        this.hat.y += 12.0f;
        this.head.visible = true;
        this.body.y += 12.0f;
        this.leftArm.y += 12.0f;
        this.rightArm.y += 12.0f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        int animationTick = ((AstralGolem)((Object)entity)).getAttackAnimationTick();
        this.armXRot = animationTick > 0 ? -2.0f + 1.5f * Mth.triangleWave((float)((float)animationTick - partialTick), (float)10.0f) : 0.0f;
        if (((AstralGolem)((Object)entity)).isGolemBlocking()) {
            this.leftArmPose = HumanoidModel.ArmPose.BLOCK;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, this.tintColor == -1 ? color : FastColor.ARGB32.multiply((int)color, (int)this.tintColor));
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, this.tintColor == -1 ? color : FastColor.ARGB32.multiply((int)color, (int)this.tintColor));
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, this.tintColor == -1 ? color : FastColor.ARGB32.multiply((int)color, (int)this.tintColor));
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, this.tintColor == -1 ? color : FastColor.ARGB32.multiply((int)color, (int)this.tintColor));
    }
}

