/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AethersentMeteorRenderer
extends EntityRenderer<AethersentMeteor> {
    private final BlockRenderDispatcher dispatcher;

    public AethersentMeteorRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(AethersentMeteor meteor, float yaw, float delta, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        Level level;
        BlockState state = ESBlocks.RAW_AETHERSENT_BLOCK.get().defaultBlockState();
        if (state.getRenderShape() == RenderShape.MODEL && state != (level = meteor.level()).getBlockState(meteor.blockPosition()) && state.getRenderShape() != RenderShape.INVISIBLE) {
            stack.pushPose();
            BlockPos pos = BlockPos.containing((double)meteor.getX(), (double)meteor.getBoundingBox().maxY, (double)meteor.getZ());
            float scale = (float)meteor.getSize() / 10.0f;
            stack.translate(-0.5 * (double)scale, 0.0, -0.5 * (double)scale);
            stack.scale(scale, scale, scale);
            ESPlatform.INSTANCE.renderBlock(this.dispatcher, stack, bufferSource, level, state, pos, state.getSeed(meteor.blockPosition()));
            stack.popPose();
            super.render((Entity)meteor, yaw, delta, stack, bufferSource, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(AethersentMeteor meteor) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

