/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.TangledSkullModel;
import cn.leolezury.eternalstarlight.common.entity.living.monster.TangledSkull;
import cn.leolezury.eternalstarlight.common.util.Easing;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TangledSkullRenderer<T extends TangledSkull>
extends MobRenderer<T, TangledSkullModel<T>> {
    public static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/tangled_skull.png");

    public TangledSkullRenderer(EntityRendererProvider.Context context) {
        super(context, new TangledSkullModel(context.bakeLayer(TangledSkullModel.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(T entity, PoseStack poseStack, float f) {
        float progress = Math.min(((float)((TangledSkull)((Object)entity)).skullDeathTime + f) / 80.0f, 1.0f);
        float swell = progress * 8.0f;
        float factor = 1.0f + Mth.sin((float)(swell * 100.0f)) * swell * 0.01f;
        swell = progress;
        swell = Mth.clamp((float)swell, (float)0.0f, (float)1.0f);
        swell *= swell;
        swell *= swell;
        float xz = (1.0f + swell * 0.4f) * factor;
        float y = (1.0f + swell * 0.1f) / factor;
        if (((TangledSkull)((Object)entity)).isShotFromMonstrosity()) {
            y = Easing.OUT_ELASTIC.calculate(Math.min(((float)((TangledSkull)((Object)entity)).tickCount + f) / 30.0f, 1.0f));
        }
        poseStack.scale(xz, y, xz);
    }

    protected float getFlipDegrees(T entity) {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(T entity, float f) {
        float g = Math.min(((float)((TangledSkull)((Object)entity)).skullDeathTime + f) / 80.0f, 1.0f);
        return (int)(g * 20.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)g, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ENTITY_TEXTURE;
    }
}

