/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.TheGatekeeperModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.TheGatekeeperClothingLayer;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TheGatekeeperRenderer<T extends TheGatekeeper>
extends MobRenderer<T, TheGatekeeperModel<T>> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/the_gatekeeper.png");
    private static final ResourceLocation SLIM_ENTITY_TEXTURE = EternalStarlight.id("textures/entity/the_gatekeeper_slim.png");
    private static final Map<String, GameProfile> PROFILES = new HashMap<String, GameProfile>();
    private final TheGatekeeperModel<T> normalModel = (TheGatekeeperModel)this.getModel();
    private final TheGatekeeperModel<T> slimModel;

    public TheGatekeeperRenderer(EntityRendererProvider.Context context) {
        super(context, new TheGatekeeperModel(context.bakeLayer(TheGatekeeperModel.LAYER_LOCATION), false), 0.5f);
        this.slimModel = new TheGatekeeperModel(context.bakeLayer(TheGatekeeperModel.SLIM_LAYER_LOCATION), true);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer(new TheGatekeeperClothingLayer(this, context.getModelSet()));
    }

    public void render(T entity, float f1, float f2, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        SkinManager skinManager = Minecraft.getInstance().getSkinManager();
        TheGatekeeperRenderer.getGameProfile(entity).ifPresent(p -> {
            this.model = skinManager.getInsecureSkin(p).model() == PlayerSkin.Model.SLIM ? this.slimModel : this.normalModel;
        });
        super.render(entity, f1, f2, stack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(T entity) {
        PlayerSkin playerSkin;
        ResourceLocation texture = this.model == this.slimModel ? SLIM_ENTITY_TEXTURE : ENTITY_TEXTURE;
        SkinManager skinManager = Minecraft.getInstance().getSkinManager();
        Optional<GameProfile> profile = TheGatekeeperRenderer.getGameProfile(entity);
        if (profile.isPresent() && (playerSkin = (PlayerSkin)skinManager.getOrLoad(profile.get()).getNow(null)) != null && !playerSkin.texture().getPath().startsWith("textures/entity/player/")) {
            texture = playerSkin.texture();
        }
        return texture;
    }

    public static Optional<GameProfile> getGameProfile(TheGatekeeper entity) {
        if (entity.getCustomName() != null) {
            String customName = entity.getCustomName().getString();
            if (!PROFILES.containsKey(customName)) {
                SkullBlockEntity.fetchGameProfile((String)customName).thenAccept(optional -> optional.ifPresent(p -> PROFILES.put(customName, (GameProfile)p)));
            }
            if (PROFILES.containsKey(customName)) {
                return Optional.ofNullable(PROFILES.get(customName));
            }
        }
        return Optional.empty();
    }
}

