/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.animal;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.goal.RandomFlyGoal;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CrystallizedMoth
extends TamableAnimal
implements FlyingAnimal,
NeutralMob {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private static final Ingredient FOOD_ITEMS = Ingredient.of(ESTags.Items.CRYSTALLIZED_MOTH_FOOD);
    protected static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.defineId(CrystallizedMoth.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public AnimationState idleAnimationState = new AnimationState();

    public int getAttackTicks() {
        return (Integer)this.getEntityData().get(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.getEntityData().set(ATTACK_TICKS, (Object)attackTicks);
    }

    public CrystallizedMoth(EntityType<? extends CrystallizedMoth> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new MothMoveControl();
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, -1.0f);
        this.setNoGravity(true);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation pathNavigation = new FlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos blockPos) {
                return this.level.getBlockState(blockPos).isAir();
            }
        };
        pathNavigation.setCanOpenDoors(false);
        pathNavigation.setCanFloat(true);
        pathNavigation.setCanPassDoors(true);
        return pathNavigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TICKS, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new CrystallizedMothAttackGoal());
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)new RandomFlyGoal((PathfinderMob)this){

            @Override
            public boolean canUse() {
                return super.canUse() && CrystallizedMoth.this.getAttackTicks() <= 0;
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && CrystallizedMoth.this.getAttackTicks() <= 0;
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Bat.class, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int i) {
        this.remainingPersistentAngerTime = i;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.getRandom()));
    }

    public boolean hurt(DamageSource source, float amount) {
        return !source.is(ESDamageTypes.SONAR) && super.hurt(source, amount);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.crystallizedMoth.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.crystallizedMoth.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.crystallizedMoth.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.crystallizedMoth.followRange()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.6);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public boolean isFood(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!(!this.level().isClientSide || this.isBaby() && this.isFood(itemStack))) {
            boolean bl = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.isFood(itemStack) && !this.isTame() && !this.isAngry();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(itemStack) && this.getHealth() < this.getMaxHealth()) {
                itemStack.consume(1, (LivingEntity)player);
                FoodProperties foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD);
                float f = foodProperties != null ? (float)foodProperties.nutrition() : 1.0f;
                this.heal(2.0f * f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            if (itemStack.getItem() == ESItems.LUNARIS_CACTUS_GEL.get()) {
                itemStack.consume(1, (LivingEntity)player);
                if (this.random.nextInt(5) == 0) {
                    ItemEntity itemEntity = this.spawnAtLocation((ItemLike)ESItems.SHIVERING_GEL.get(), 1);
                    if (itemEntity != null) {
                        itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f), (double)(this.getRandom().nextFloat() * 0.05f), (double)((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f)));
                    }
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (this.isFood(itemStack) && !this.isAngry()) {
            itemStack.consume(1, (LivingEntity)player);
            this.tryToTame(player);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    private void tryToTame(Player player) {
        if (this.random.nextInt(3) == 0) {
            this.tame(player);
            this.getNavigation().stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            boolean bl;
            LivingEntity livingEntity = target;
            Objects.requireNonNull(livingEntity);
            LivingEntity livingEntity2 = livingEntity;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CrystallizedMoth.class, Player.class, AbstractHorse.class}, (Object)livingEntity2, n)) {
                    case 0: {
                        CrystallizedMoth moth = (CrystallizedMoth)livingEntity2;
                        if (!moth.isTame() || moth.getOwner() != owner) {
                            bl = true;
                            break block5;
                        }
                        bl = false;
                        break block5;
                    }
                    case 1: {
                        Player playerOwner;
                        Player playerTarget = (Player)livingEntity2;
                        if (!(owner instanceof Player) || (playerOwner = (Player)owner).canHarmPlayer(playerTarget)) {
                            n = 2;
                            continue block5;
                        }
                        bl = false;
                        break block5;
                    }
                    case 2: {
                        AbstractHorse horse = (AbstractHorse)livingEntity2;
                        if (!horse.isTamed()) {
                            n = 3;
                            continue block5;
                        }
                        bl = false;
                        break block5;
                    }
                    default: {
                        TamableAnimal animal;
                        if (!(target instanceof TamableAnimal) || !(animal = (TamableAnimal)target).isTame()) {
                            bl = true;
                            break block5;
                        }
                        bl = false;
                        break block5;
                    }
                }
                break;
            }
            return bl;
        }
        return false;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingEntity = this.getOwner();
        return livingEntity != null && this.distanceToSqr((Entity)this.getOwner()) >= 400.0;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        CrystallizedMoth moth = (CrystallizedMoth)ESEntities.CRYSTALLIZED_MOTH.get().create((Level)level);
        if (this.isTame() && moth != null) {
            moth.setOwnerUUID(this.getOwnerUUID());
            moth.setTame(true, true);
        }
        return moth;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public static boolean checkMothSpawnRules(EntityType<? extends CrystallizedMoth> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return !level.canSeeSky(pos) && pos.getY() < level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()) - 20 && ESConfig.INSTANCE.mobsConfig.crystallizedMoth.canSpawn();
    }

    private class MothMoveControl
    extends MoveControl {
        public MothMoveControl() {
            super((Mob)CrystallizedMoth.this);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
                double length = vec3.length();
                double size = this.mob.getBoundingBox().getSize();
                Vec3 delta = vec3.scale(this.speedModifier * 0.025 / length);
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(delta));
                if (length < size * 0.5) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.2));
                } else if (length >= size && CrystallizedMoth.this.getAttackTicks() <= 0) {
                    this.mob.setYRot(-((float)Mth.atan2((double)delta.x, (double)delta.z)) * 57.295776f);
                }
            }
            this.mob.setNoGravity(true);
        }
    }

    private class CrystallizedMothAttackGoal
    extends Goal {
        public CrystallizedMothAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return CrystallizedMoth.this.getTarget() != null && CrystallizedMoth.this.getAttackTicks() == 0 && CrystallizedMoth.this.random.nextInt(50) == 0;
        }

        public boolean canContinueToUse() {
            return CrystallizedMoth.this.getAttackTicks() < 100;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            CrystallizedMoth.this.setAttackTicks(CrystallizedMoth.this.getAttackTicks() + 1);
            if (CrystallizedMoth.this.getTarget() != null) {
                Level level;
                LivingEntity target = CrystallizedMoth.this.getTarget();
                CrystallizedMoth.this.getLookControl().setLookAt((Entity)target, 360.0f, 360.0f);
                Vec3 selfPos = CrystallizedMoth.this.position().add(0.0, (double)(CrystallizedMoth.this.getBbHeight() / 2.0f), 0.0);
                Vec3 pos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                Vec3 subtract = pos.subtract(selfPos);
                CrystallizedMoth.this.setYRot(-((float)Mth.atan2((double)subtract.x, (double)subtract.z)) * 57.295776f);
                if (CrystallizedMoth.this.getAttackTicks() > 15 && CrystallizedMoth.this.hasLineOfSight((Entity)target) && CrystallizedMoth.this.distanceTo((Entity)target) < 30.0f) {
                    target.hurt(ESDamageTypes.getEntityDamageSource(CrystallizedMoth.this.level(), ESDamageTypes.SONAR, (Entity)CrystallizedMoth.this), (float)CrystallizedMoth.this.getAttributeValue(Attributes.ATTACK_DAMAGE) * (float)(target.getType().is(ESTags.EntityTypes.VULNERABLE_TO_SONAR_BOMB) ? 4 : 1));
                }
                if ((level = CrystallizedMoth.this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (CrystallizedMoth.this.getAttackTicks() % 5 == 0) {
                        Vec3 delta = pos.subtract(selfPos).normalize().scale(0.8);
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ESParticles.CRYSTALLIZED_MOTH_SONAR.get(), selfPos.x, selfPos.y, selfPos.z, delta.x, delta.y, delta.z));
                        ScreenShakeVfx.createInstance((ResourceKey<Level>)CrystallizedMoth.this.level().dimension(), CrystallizedMoth.this.position(), 30.0f, 15, 0.15f, 0.24f, 4.0f, 5.0f).send(serverLevel);
                    }
                }
                Vec3 wanted = ESMathUtil.rotationToPosition(pos, 10.0f, 0.0f, ESMathUtil.positionToYaw(pos, selfPos) + 5.0f);
                CrystallizedMoth.this.getMoveControl().setWantedPosition(wanted.x, wanted.y, wanted.z, 1.0);
            }
        }

        public void stop() {
            CrystallizedMoth.this.setAttackTicks(0);
        }
    }
}

