/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.attack.EnergizedFlame;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.Permafrost;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Freeze;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class FrozenTube
extends ThrowableProjectile
implements TrailOwner {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");

    public FrozenTube(EntityType<? extends FrozenTube> entityType, Level level) {
        super(entityType, level);
    }

    public FrozenTube(Level level, LivingEntity livingEntity) {
        super(ESEntities.FROZEN_TUBE.get(), livingEntity, level);
    }

    public FrozenTube(Level level, double x, double y, double z) {
        super(ESEntities.FROZEN_TUBE.get(), x, y, z, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (hitResult.getType() != HitResult.Type.MISS) {
            this.playSound(ESSoundEvents.FROZEN_TUBE_BREAK.get(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, ESItems.FROZEN_TUBE.get().getDefaultInstance()), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            }
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0))) {
                if (this.level().isClientSide || !ESEntityUtil.shouldHarm(this.getOwner(), (Entity)entity)) continue;
                if (entity.canFreeze()) {
                    entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 100, 300));
                }
                if (!(this.getOwner() instanceof Player) || !(entity instanceof StarlightGolem)) continue;
                StarlightGolem golem = (StarlightGolem)entity;
                golem.setAttackEnergy(Math.max(golem.getAttackEnergy() - 3, 0));
            }
            for (int x = -4; x <= 4; ++x) {
                for (int y = -4; y <= 4; ++y) {
                    for (int z = -4; z <= 4; ++z) {
                        BlockPos pos = this.blockPosition().offset(x, y, z);
                        if (this.level().getBlockState(pos).is(Blocks.FIRE) && this.blockPosition().distSqr((Vec3i)pos) <= 16.0) {
                            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                        if (this.level().getBlockState(pos).is(Blocks.WATER) && this.level().getFluidState(pos).isSource() && this.blockPosition().distSqr((Vec3i)pos) <= 16.0) {
                            this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                        }
                        if (!this.level().getBlockState(pos).is(Blocks.LAVA) || !this.level().getFluidState(pos).isSource() || !(this.blockPosition().distSqr((Vec3i)pos) <= 4.0)) continue;
                        this.level().setBlockAndUpdate(pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                    }
                }
            }
            this.level().getEntitiesOfClass(EnergizedFlame.class, this.getBoundingBox().inflate(5.0)).forEach(Entity::discard);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        LivingEntity owner;
        Entity entity;
        if (hitResult.getType() != HitResult.Type.MISS && (entity = this.getOwner()) instanceof LivingEntity && ESEntityUtil.shouldHarm((Entity)(owner = (LivingEntity)entity), hitResult.getEntity())) {
            Entity entity2 = hitResult.getEntity();
            DamageSource damageSource = ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.FREEZE, (Entity)this, (Entity)owner);
            Entity entity3 = this.getOwner();
            Objects.requireNonNull(entity3);
            entity = entity3;
            int n = 0;
            entity2.hurt(damageSource, (float)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, Freeze.class, Permafrost.class}, (Object)entity, n)) {
                case 0 -> {
                    Player ignored = (Player)entity;
                    yield 6.0;
                }
                case 1 -> {
                    Freeze ignored = (Freeze)entity;
                    yield ESConfig.INSTANCE.mobsConfig.freeze.attackDamage();
                }
                case 2 -> {
                    Permafrost permafrost = (Permafrost)entity;
                    yield (permafrost.getAttribute(Attributes.ATTACK_DAMAGE) != null ? permafrost.getAttributeValue(Attributes.ATTACK_DAMAGE) : 12.0) * 0.4;
                }
                default -> 3.0;
            }));
        }
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.3f, 8);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 0.9f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.40784314f, 0.8f, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentNoDepth(TRAIL_TEXTURE);
    }
}

